/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes;

import exter.foundry.api.recipe.IMeltingRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MeltingRecipe
implements IMeltingRecipe {
    private final FluidStack fluid;
    private final IItemMatcher solid;
    private final int melting_point;
    private final int melting_speed;

    public MeltingRecipe(IItemMatcher item, FluidStack fluid_stack, int melt, int speed) {
        this.solid = item;
        if (fluid_stack == null) {
            throw new IllegalArgumentException("Melting recipe fluid cannot be null.");
        }
        this.fluid = fluid_stack.copy();
        if (melt <= 295) {
            throw new IllegalArgumentException("Melting recipe melting point must be > 295.");
        }
        this.melting_point = melt;
        if (speed < 1) {
            throw new IllegalArgumentException("Melting recipe speed must be > 0.");
        }
        this.melting_speed = speed;
    }

    @Override
    public IItemMatcher getInput() {
        return this.solid;
    }

    @Override
    public FluidStack getOutput() {
        return this.fluid.copy();
    }

    @Override
    public int getMeltingPoint() {
        return this.melting_point;
    }

    @Override
    public boolean matchesRecipe(ItemStack item) {
        return this.solid.apply(item);
    }

    @Override
    public int getMeltingSpeed() {
        return this.melting_speed;
    }
}

