/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes;

import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CastingRecipe
implements ICastingRecipe {
    private final FluidStack fluid;
    private final ItemStack mold;
    private final IItemMatcher extra;
    private final IItemMatcher output;
    private final int speed;

    @Override
    public FluidStack getInput() {
        return this.fluid.copy();
    }

    @Override
    public ItemStack getMold() {
        return this.mold.func_77946_l();
    }

    @Override
    public boolean containsExtra(ItemStack stack) {
        if (stack == null) {
            return this.extra == null;
        }
        return this.extra.apply(stack);
    }

    @Override
    public boolean requiresExtra() {
        return this.extra != null;
    }

    @Override
    public IItemMatcher getInputExtra() {
        return this.extra;
    }

    @Override
    public ItemStack getOutput() {
        return this.output.getItem();
    }

    public CastingRecipe(IItemMatcher result, FluidStack in_fluid, ItemStack in_mold, IItemMatcher in_extra, int cast_speed) {
        if (result == null) {
            throw new IllegalArgumentException("Casting recipe result cannot be null.");
        }
        this.output = result;
        if (in_fluid == null) {
            throw new IllegalArgumentException("Casting recipe fluid cannot be null.");
        }
        this.fluid = in_fluid.copy();
        if (in_mold == null) {
            throw new IllegalArgumentException("Casting recipe mold cannot be null.");
        }
        this.mold = in_mold.func_77946_l();
        this.extra = in_extra;
        if (cast_speed < 1) {
            throw new IllegalArgumentException("Casting recipe speed must be > 0.");
        }
        this.speed = cast_speed;
    }

    @Override
    public boolean matchesRecipe(ItemStack mold_stack, FluidStack fluid_stack, ItemStack in_extra) {
        if (this.getOutput() == null) {
            return false;
        }
        return fluid_stack != null && fluid_stack.containsFluid(this.fluid) && mold_stack != null && this.mold.func_77969_a(mold_stack) && ItemStack.func_77970_a((ItemStack)this.mold, (ItemStack)mold_stack) && (this.extra == null || this.extra.apply(in_extra));
    }

    @Override
    public int getCastingSpeed() {
        return this.speed;
    }

    @Override
    public IItemMatcher getOutputMatcher() {
        return this.output;
    }
}

