/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes;

import exter.foundry.api.recipe.IAtomizerRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class AtomizerRecipe
implements IAtomizerRecipe {
    private final FluidStack fluid;
    private final IItemMatcher output;

    @Override
    public FluidStack getInput() {
        return this.fluid.copy();
    }

    @Override
    public ItemStack getOutput() {
        return this.output.getItem();
    }

    public AtomizerRecipe(IItemMatcher result, FluidStack in_fluid) {
        this.output = result;
        if (in_fluid == null) {
            throw new IllegalArgumentException("Atomizer recipe input cannot be null");
        }
        this.fluid = in_fluid.copy();
    }

    @Override
    public boolean matchesRecipe(FluidStack fluid_stack) {
        if (this.getOutput() == null) {
            return false;
        }
        return fluid_stack != null && fluid_stack.containsFluid(this.fluid);
    }

    @Override
    public IItemMatcher getOutputMatcher() {
        return this.output;
    }
}

