/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes;

import exter.foundry.api.recipe.IAlloyMixerRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class AlloyMixerRecipe
implements IAlloyMixerRecipe {
    public List<FluidStack> inputs;
    public FluidStack output;
    private static final boolean[] matched = new boolean[4];

    @Override
    public FluidStack getOutput() {
        return this.output.copy();
    }

    public AlloyMixerRecipe(FluidStack out, FluidStack[] in) {
        this.output = out.copy();
        if (in == null) {
            throw new IllegalArgumentException("Alloy mixer recipe inputs cannot be null");
        }
        if (in.length > 4) {
            throw new IllegalArgumentException("Alloy mixer recipe cannot have more the 4 inputs");
        }
        this.inputs = new ArrayList<FluidStack>();
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) {
                throw new IllegalArgumentException("Alloy mixer recipe input cannot be null");
            }
            this.inputs.add(in[i].copy());
        }
        this.inputs = Collections.unmodifiableList(this.inputs);
    }

    @Override
    public List<FluidStack> getInputs() {
        return this.inputs;
    }

    @Override
    public boolean matchesRecipe(FluidStack[] in, int[] order) {
        int i;
        int matches = 0;
        if (order != null && order.length < this.inputs.size()) {
            order = null;
        }
        if (in.length < this.inputs.size()) {
            return false;
        }
        for (i = 0; i < 4; ++i) {
            AlloyMixerRecipe.matched[i] = false;
        }
        block1: for (i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            for (int j = 0; j < this.inputs.size(); ++j) {
                if (matched[j] || !in[i].containsFluid(this.inputs.get(j))) continue;
                AlloyMixerRecipe.matched[j] = true;
                ++matches;
                if (order == null) continue block1;
                order[j] = i;
                continue block1;
            }
        }
        return matches == this.inputs.size();
    }
}

