/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.proxy;

import exter.foundry.block.BlockCastingTable;
import exter.foundry.block.BlockComponent;
import exter.foundry.block.BlockFoundryMachine;
import exter.foundry.block.FoundryBlocks;
import exter.foundry.config.FoundryConfig;
import exter.foundry.entity.EntitySkeletonGun;
import exter.foundry.fluid.FluidLiquidMetal;
import exter.foundry.fluid.LiquidMetalRegistry;
import exter.foundry.integration.ModIntegrationManager;
import exter.foundry.item.FoundryItems;
import exter.foundry.item.ItemComponent;
import exter.foundry.item.ItemMold;
import exter.foundry.material.MaterialRegistry;
import exter.foundry.material.OreDictMaterial;
import exter.foundry.material.OreDictType;
import exter.foundry.model.RFCModel;
import exter.foundry.proxy.CommonFoundryProxy;
import exter.foundry.tileentity.TileEntityCastingTableBlock;
import exter.foundry.tileentity.TileEntityCastingTableIngot;
import exter.foundry.tileentity.TileEntityCastingTablePlate;
import exter.foundry.tileentity.TileEntityCastingTableRod;
import exter.foundry.tileentity.TileEntityInfernoTank;
import exter.foundry.tileentity.TileEntityRefractoryHopper;
import exter.foundry.tileentity.TileEntityRefractorySpout;
import exter.foundry.tileentity.TileEntityRefractoryTank;
import exter.foundry.tileentity.renderer.CastingTableRenderer;
import exter.foundry.tileentity.renderer.CastingTableRendererBlock;
import exter.foundry.tileentity.renderer.HopperRenderer;
import exter.foundry.tileentity.renderer.SpoutRenderer;
import exter.foundry.tileentity.renderer.TankRenderer;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSkeleton;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ClientFoundryProxy
extends CommonFoundryProxy {
    private void registerItemModel(Block block, String name) {
        this.registerItemModel(Item.func_150898_a((Block)block), name);
    }

    private void registerItemModel(Block block, String name, int meta) {
        this.registerItemModel(Item.func_150898_a((Block)block), name, meta);
    }

    private void registerItemModel(Item item, String name) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation("foundry:" + name, "inventory"));
    }

    private void registerItemModel(Item item, String name, int meta) {
        name = "foundry:" + name;
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(name)});
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, new ModelResourceLocation(name, "inventory"));
    }

    @Override
    public void preInit() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)RFCModel.Loader.instance);
        MaterialRegistry.instance.initIcons();
        for (Map.Entry<String, FluidLiquidMetal> e : LiquidMetalRegistry.instance.getFluids().entrySet()) {
            Fluid fluid = e.getValue();
            Block block = fluid.getBlock();
            Item item = Item.func_150898_a((Block)block);
            String name = e.getKey();
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new LiquidMetalItemMeshDefinition(name));
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidBase.LEVEL}).func_178441_a());
        }
        RenderingRegistry.registerEntityRenderingHandler(EntitySkeletonGun.class, (IRenderFactory)new IRenderFactory<EntitySkeleton>(){

            public Render<EntitySkeleton> createRenderFor(RenderManager manager) {
                return new RenderSkeleton(manager);
            }
        });
        ModIntegrationManager.clientPreInit();
    }

    @Override
    public void init() {
        for (BlockFoundryMachine.EnumMachine enumMachine : BlockFoundryMachine.EnumMachine.values()) {
            this.registerItemModel(FoundryBlocks.block_machine, enumMachine.model, enumMachine.id);
        }
        for (Enum enum_ : BlockCastingTable.EnumTable.values()) {
            this.registerItemModel(FoundryBlocks.block_casting_table, ((BlockCastingTable.EnumTable)enum_).model, ((BlockCastingTable.EnumTable)enum_).id);
        }
        this.registerItemModel((Block)FoundryBlocks.block_refractory_glass, "refractoryGlass");
        this.registerItemModel((Block)FoundryBlocks.block_alloy_furnace, "alloyFurnace");
        this.registerItemModel((Block)FoundryBlocks.block_mold_station, "moldStation");
        this.registerItemModel((Block)FoundryBlocks.block_refractory_hopper, "refractoryHopper");
        this.registerItemModel((Block)FoundryBlocks.block_burner_heater, "burnerHeater");
        this.registerItemModel((Block)FoundryBlocks.block_refractory_spout, "refractorySpout");
        this.registerItemModel((Block)FoundryBlocks.block_refractory_tank, "refractoryTank");
        this.registerItemModel((Block)FoundryBlocks.block_inferno_tank, "infernoTank");
        if (FoundryConfig.block_cokeoven) {
            this.registerItemModel((Block)FoundryBlocks.block_coke_oven, "cokeOven");
        }
        for (Enum enum_ : BlockComponent.EnumVariant.values()) {
            this.registerItemModel(FoundryBlocks.block_component, ((BlockComponent.EnumVariant)enum_).model, ((BlockComponent.EnumVariant)enum_).id);
        }
        for (Enum enum_ : ItemComponent.SubItem.values()) {
            this.registerItemModel(FoundryItems.item_component, ((ItemComponent.SubItem)enum_).name, ((ItemComponent.SubItem)enum_).id);
        }
        for (Enum enum_ : ItemMold.SubItem.values()) {
            this.registerItemModel(FoundryItems.item_mold, ((ItemMold.SubItem)enum_).name, ((ItemMold.SubItem)enum_).id);
        }
        this.registerItemModel(FoundryItems.item_revolver, "revolver", 0);
        this.registerItemModel(FoundryItems.item_shotgun, "shotgun", 0);
        this.registerItemModel(FoundryItems.item_round, "roundNormal", 0);
        this.registerItemModel(FoundryItems.item_round_hollow, "roundHollow", 0);
        this.registerItemModel(FoundryItems.item_round_jacketed, "roundJacketed", 0);
        this.registerItemModel(FoundryItems.item_round_fire, "roundFire", 0);
        this.registerItemModel(FoundryItems.item_round_poison, "roundPoison", 0);
        this.registerItemModel(FoundryItems.item_round_ap, "roundAP", 0);
        this.registerItemModel(FoundryItems.item_round_lumium, "roundLumium", 0);
        this.registerItemModel(FoundryItems.item_round_snow, "roundSnow", 0);
        this.registerItemModel(FoundryItems.item_shell, "shellNormal", 0);
        this.registerItemModel(FoundryItems.item_shell_ap, "shellAP", 0);
        this.registerItemModel(FoundryItems.item_shell_lumium, "shellLumium", 0);
        this.registerItemModel(FoundryItems.item_container, "container", 0);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCastingTableIngot.class, (TileEntitySpecialRenderer)new CastingTableRenderer(6, 10, 4, 12, 9, 12, "foundry:blocks/castingtable_top_ingot"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCastingTablePlate.class, (TileEntitySpecialRenderer)new CastingTableRenderer(3, 13, 3, 13, 11, 12, "foundry:blocks/castingtable_top_plate"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCastingTableRod.class, (TileEntitySpecialRenderer)new CastingTableRenderer(7, 9, 2, 14, 10, 12, "foundry:blocks/castingtable_top_rod"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCastingTableBlock.class, (TileEntitySpecialRenderer)new CastingTableRendererBlock());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRefractorySpout.class, (TileEntitySpecialRenderer)new SpoutRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRefractoryHopper.class, (TileEntitySpecialRenderer)new HopperRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRefractoryTank.class, (TileEntitySpecialRenderer)new TankRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityInfernoTank.class, (TileEntitySpecialRenderer)new TankRenderer());
        ModIntegrationManager.clientInit();
    }

    @Override
    public void postInit() {
        List ores;
        block0: for (OreDictMaterial material : OreDictMaterial.MATERIALS) {
            ores = OreDictionary.getOres((String)(material.default_prefix + material.suffix));
            if (ores.size() > 0) {
                MaterialRegistry.instance.registerMaterialIcon(material.suffix, (ItemStack)ores.get(0));
                continue;
            }
            for (OreDictType type : OreDictType.TYPES) {
                ores = OreDictionary.getOres((String)(type.prefix + material.suffix));
                if (ores.size() <= 0) continue;
                MaterialRegistry.instance.registerMaterialIcon(material.suffix, (ItemStack)ores.get(0));
                continue block0;
            }
        }
        block2: for (OreDictType type : OreDictType.TYPES) {
            ores = OreDictionary.getOres((String)(type.prefix + type.default_suffix));
            if (ores.size() > 0) {
                MaterialRegistry.instance.registerTypeIcon(type.name, (ItemStack)ores.get(0));
                continue;
            }
            for (OreDictMaterial material : OreDictMaterial.MATERIALS) {
                ores = OreDictionary.getOres((String)(type.prefix + material.suffix));
                if (ores.size() <= 0) continue;
                MaterialRegistry.instance.registerTypeIcon(type.name, (ItemStack)ores.get(0));
                continue block2;
            }
        }
        ModIntegrationManager.clientPostInit();
    }

    private static class LiquidMetalItemMeshDefinition
    implements ItemMeshDefinition {
        private ModelResourceLocation model;

        LiquidMetalItemMeshDefinition(String name) {
            this.model = new ModelResourceLocation("foundry:liquid" + name);
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.model;
        }
    }
}

