/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.network;

import exter.foundry.ModFoundry;
import exter.foundry.config.FoundryConfig;
import exter.foundry.tileentity.TileEntityFoundry;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageTileEntitySync
implements IMessage {
    NBTTagCompound data;

    @SideOnly(value=Side.CLIENT)
    private static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public MessageTileEntitySync() {
    }

    public MessageTileEntitySync(NBTTagCompound data) {
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        int len = buf.readInt();
        byte[] bytes = new byte[len];
        buf.readBytes(bytes);
        try {
            ByteArrayInputStream s = new ByteArrayInputStream(bytes);
            this.data = CompressedStreamTools.func_74796_a((InputStream)s);
            s.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.data, (OutputStream)stream);
            byte[] bytes = stream.toByteArray();
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageTileEntitySync, IMessage> {
        public IMessage onMessage(MessageTileEntitySync message, MessageContext ctx) {
            Minecraft main_thread;
            World world;
            if (ctx.side == Side.SERVER) {
                world = ctx.getServerHandler().field_147369_b.field_70170_p;
                main_thread = (WorldServer)world;
            } else {
                world = MessageTileEntitySync.getClientWorld();
                main_thread = Minecraft.func_71410_x();
            }
            main_thread.func_152344_a((Runnable)new SyncRunnable(message.data, world));
            return null;
        }
    }

    private static class SyncRunnable
    implements Runnable {
        private NBTTagCompound data;
        private World world;

        public SyncRunnable(NBTTagCompound data, World world) {
            this.data = data;
            this.world = world;
        }

        @Override
        public void run() {
            int x = this.data.func_74762_e("x");
            int y = this.data.func_74762_e("y");
            int z = this.data.func_74762_e("z");
            int dim = this.data.func_74762_e("dim");
            if (dim == this.world.field_73011_w.getDimension()) {
                TileEntityFoundry tile = (TileEntityFoundry)this.world.func_175625_s(new BlockPos(x, y, z));
                if (tile != null) {
                    tile.func_145839_a(this.data);
                    if (!this.world.field_72995_K) {
                        tile.func_70296_d();
                    }
                } else if (FoundryConfig.debug) {
                    ModFoundry.log.debug("TileEntitySync: Unexpected null tile at " + x + ", " + y + ", " + z + ", " + dim);
                }
            }
        }
    }
}

