/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import exter.foundry.item.FoundryItems;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class RFCModel
implements IModel {
    public static final RFCModel instance = new RFCModel();
    private final ResourceLocation texture_fg = new ResourceLocation("foundry", "items/container_foreground");
    private final ResourceLocation texture_bg = new ResourceLocation("foundry", "items/container_background");
    private static final IModelState DEFAULT_STATE;

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Optional transform = state.apply(Optional.absent());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(RFCModel.getQuadsForSprite(0, (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.texture_bg), format, (Optional<TRSRTransformation>)transform));
        builder.addAll(RFCModel.getQuadsForSprite(2, (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.texture_fg), format, (Optional<TRSRTransformation>)transform));
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        return new BakedItemModel((ImmutableList<BakedQuad>)builder.build(), (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.texture_fg), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, null, bakedTextureGetter, format, (Optional<TRSRTransformation>)transform);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)this.texture_fg, (Object)this.texture_bg);
    }

    public IModelState getDefaultState() {
        return DEFAULT_STATE;
    }

    public static ImmutableList<BakedQuad> getQuadsForSprite(int tint, TextureAtlasSprite sprite, VertexFormat format, Optional<TRSRTransformation> transform) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.func_94211_a();
        int vMax = sprite.func_94216_b();
        BitSet faces = new BitSet((uMax + 1) * (vMax + 1) * 4);
        for (int f = 0; f < sprite.func_110970_k(); ++f) {
            int[] pixels = sprite.func_147965_a(f)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (int u = 0; u < uMax; ++u) {
                    boolean t = RFCModel.isTransparent(pixels, uMax, vMax, u, v);
                    if (ptu && !t) {
                        RFCModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.WEST, tint, sprite, uMax, vMax, u, v);
                    }
                    if (!ptu && t) {
                        RFCModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.EAST, tint, sprite, uMax, vMax, u, v);
                    }
                    if (ptv[u] && !t) {
                        RFCModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.UP, tint, sprite, uMax, vMax, u, v);
                    }
                    if (!ptv[u] && t) {
                        RFCModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.DOWN, tint, sprite, uMax, vMax, u, v);
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu) continue;
                RFCModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.EAST, tint, sprite, uMax, vMax, uMax, v);
            }
            for (int u = 0; u < uMax; ++u) {
                if (ptv[u]) continue;
                RFCModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.DOWN, tint, sprite, uMax, vMax, u, vMax);
            }
        }
        builder.add((Object)RFCModel.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, 0.0f, 0.0f, 0.46875f - 2.0E-4f * (float)tint, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f - 2.0E-4f * (float)tint, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f - 2.0E-4f * (float)tint, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f - 2.0E-4f * (float)tint, sprite.func_94212_f(), sprite.func_94210_h(), -1));
        builder.add((Object)RFCModel.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, 0.0f, 0.0f, 0.53125f + 2.0E-4f * (float)tint, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f + 2.0E-4f * (float)tint, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f + 2.0E-4f * (float)tint, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f + 2.0E-4f * (float)tint, sprite.func_94209_e(), sprite.func_94206_g(), -1));
        return builder.build();
    }

    public static ImmutableList<BakedQuad> getQuadsForSpriteSlice(int tint, TextureAtlasSprite sprite, VertexFormat format, int min_x, int min_y, int max_x, int max_y, int color, Optional<TRSRTransformation> transform) {
        ImmutableList.Builder builder = ImmutableList.builder();
        float min_u = sprite.func_94214_a((double)min_x);
        float min_v = sprite.func_94207_b((double)min_y);
        float max_u = sprite.func_94214_a((double)max_x);
        float max_v = sprite.func_94207_b((double)max_y);
        float x1 = (float)min_x / 16.0f;
        float y1 = (float)min_y / 16.0f;
        float x2 = (float)max_x / 16.0f;
        float y2 = (float)max_y / 16.0f;
        float z1 = 0.46875f - 2.0E-4f * (float)tint;
        float z2 = 0.53125f + 2.0E-4f * (float)tint;
        builder.add((Object)RFCModel.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, x1, y1, z1, min_u, max_v, x1, y2, z1, min_u, min_v, x2, y2, z1, max_u, min_v, x2, y1, z1, max_u, max_v, color));
        builder.add((Object)RFCModel.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, x1, y1, z2, min_u, max_v, x2, y1, z2, max_u, max_v, x2, y2, z2, max_u, min_v, x1, y2, z2, min_u, min_v, color));
        return builder.build();
    }

    private static boolean isTransparent(int[] pixels, int uMax, int vMax, int u, int v) {
        return (pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF) == 0;
    }

    private static void addSideQuad(ImmutableList.Builder<BakedQuad> builder, BitSet faces, VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int uMax, int vMax, int u, int v) {
        int index;
        int si = side.ordinal();
        if (si > 4) {
            si -= 2;
        }
        if (!faces.get(index = (vMax + 1) * ((uMax + 1) * si + u) + v)) {
            faces.set(index);
            builder.add((Object)RFCModel.buildSideQuad(format, transform, side, tint, sprite, u, v));
        }
    }

    private static BakedQuad buildSideQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int u, int v) {
        float eps0 = 3.0E-4f;
        float eps1 = 4.5E-4f;
        float eps2 = 0.5f;
        float eps3 = 0.5f;
        float x0 = (float)u / (float)sprite.func_94211_a();
        float y0 = (float)v / (float)sprite.func_94216_b();
        float x1 = x0;
        float y1 = y0;
        float z1 = 0.4683f - 2.0E-4f * (float)tint;
        float z2 = 0.5317f + 2.0E-4f * (float)tint;
        switch (side) {
            case WEST: {
                z1 = 0.5317f + 2.0E-4f * (float)tint;
                z2 = 0.4683f - 2.0E-4f * (float)tint;
            }
            case EAST: {
                y1 = ((float)v + 1.0f) / (float)sprite.func_94216_b();
                break;
            }
            case DOWN: {
                z1 = 0.5317f + 2.0E-4f * (float)tint;
                z2 = 0.4683f - 2.0E-4f * (float)tint;
            }
            case UP: {
                x1 = ((float)u + 1.0f) / (float)sprite.func_94211_a();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float u0 = 16.0f * (x0 - (float)side.func_176730_m().func_177958_n() * 0.5f / (float)sprite.func_94211_a());
        float u1 = 16.0f * (x1 - (float)side.func_176730_m().func_177958_n() * 0.5f / (float)sprite.func_94211_a());
        float v0 = 16.0f * (1.0f - y0 - (float)side.func_176730_m().func_177956_o() * 0.5f / (float)sprite.func_94216_b());
        float v1 = 16.0f * (1.0f - y1 - (float)side.func_176730_m().func_177956_o() * 0.5f / (float)sprite.func_94216_b());
        switch (side) {
            case WEST: 
            case EAST: {
                y0 -= 4.5E-4f;
                y1 += 4.5E-4f;
                v0 -= 0.5f / (float)sprite.func_94216_b();
                v1 += 0.5f / (float)sprite.func_94216_b();
                break;
            }
            case DOWN: 
            case UP: {
                x0 -= 4.5E-4f;
                x1 += 4.5E-4f;
                u0 += 0.5f / (float)sprite.func_94211_a();
                u1 -= 0.5f / (float)sprite.func_94211_a();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        switch (side) {
            case WEST: {
                x0 += 3.0E-4f;
                x1 += 3.0E-4f;
                break;
            }
            case EAST: {
                x0 -= 3.0E-4f;
                x1 -= 3.0E-4f;
                break;
            }
            case DOWN: {
                y0 -= 3.0E-4f;
                y1 -= 3.0E-4f;
                break;
            }
            case UP: {
                y0 += 3.0E-4f;
                y1 += 3.0E-4f;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        return RFCModel.buildQuad(format, transform, side.func_176734_d(), sprite, tint, x0, y0, z1, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), x1, y1, z1, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x1, y1, z2, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x0, y0, z2, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), -1);
    }

    private static final BakedQuad buildQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, TextureAtlasSprite sprite, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, int color) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        RFCModel.putVertex(builder, format, transform, side, x0, y0, z0, u0, v0, color);
        RFCModel.putVertex(builder, format, transform, side, x1, y1, z1, u1, v1, color);
        RFCModel.putVertex(builder, format, transform, side, x2, y2, z2, u2, v2, color);
        RFCModel.putVertex(builder, format, transform, side, x3, y3, z3, u3, v3, color);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, float x, float y, float z, float u, float v, int color) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    if (transform.isPresent()) {
                        vec.x = x;
                        vec.y = y;
                        vec.z = z;
                        vec.w = 1.0f;
                        ((TRSRTransformation)transform.get()).getMatrix().transform((Tuple4f)vec);
                        builder.put(e, new float[]{vec.x, vec.y, vec.z, vec.w});
                        continue block6;
                    }
                    builder.put(e, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float a = (float)(color >>> 24 & 0xFF) / 255.0f;
                    float r = (float)(color >>> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >>> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    builder.put(e, new float[]{r, g, b, a});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private RFCModel() {
    }

    static {
        TRSRTransformation tprh = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.25f, 0.03125f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, -90.0f, -55.0f)), new Vector3f(0.65f, 0.65f, 0.65f), null));
        TRSRTransformation tplh = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.25f, 0.03125f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 90.0f, 55.0f)), new Vector3f(0.65f, 0.65f, 0.65f), null));
        TRSRTransformation fprh = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.070625f, 0.2f, 0.070625f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, -90.0f, 25.0f)), new Vector3f(0.58f, 0.58f, 0.58f), null));
        TRSRTransformation fplh = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.070625f, 0.2f, 0.070625f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 90.0f, -25.0f)), new Vector3f(0.58f, 0.58f, 0.58f), null));
        TRSRTransformation gnd = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0625f, 0.0625f, 0.0f), TRSRTransformation.quatFromXYZ((float)0.0f, (float)0.0f, (float)0.0f), new Vector3f(0.58f, 0.58f, 0.58f), null));
        DEFAULT_STATE = new SimpleModelState(ImmutableMap.of((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)tplh, (Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)tprh, (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)fplh, (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)fprh, (Object)ItemCameraTransforms.TransformType.GROUND, (Object)gnd));
    }

    public static class Loader
    implements ICustomModelLoader {
        public static Loader instance = new Loader();

        private Loader() {
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("foundry") && (modelLocation.func_110623_a().equals("container") || modelLocation.func_110623_a().endsWith("/container"));
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return instance;
        }
    }

    private static final class SimpleBakedModel
    implements IPerspectiveAwareModel {
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

        public SimpleBakedModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            this.quads = quads;
            this.particle = particle;
            this.transforms = transforms;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }

    private static final class BakedItemModel
    implements IPerspectiveAwareModel {
        private final RFCOverride override = new RFCOverride();
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final IBakedModel otherModel;
        private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
        private final boolean isCulled;
        private final VertexFormat format;
        private final Optional<TRSRTransformation> transform;

        public BakedItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, IBakedModel otherModel, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, VertexFormat format, Optional<TRSRTransformation> transform) {
            this.quads = quads;
            this.particle = particle;
            this.transforms = transforms;
            this.bakedTextureGetter = bakedTextureGetter;
            this.format = format;
            this.transform = transform;
            if (otherModel != null) {
                this.otherModel = otherModel;
                this.isCulled = true;
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (BakedQuad quad : quads) {
                    if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
                    builder.add((Object)quad);
                }
                this.otherModel = new BakedItemModel((ImmutableList<BakedQuad>)builder.build(), particle, transforms, (IBakedModel)this, bakedTextureGetter, format, transform);
                this.isCulled = false;
            }
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return this.override;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            Pair pair = IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
            if (type == ItemCameraTransforms.TransformType.GUI && !this.isCulled && pair.getRight() == null) {
                return Pair.of((Object)this.otherModel, null);
            }
            if (type != ItemCameraTransforms.TransformType.GUI && this.isCulled) {
                return Pair.of((Object)this.otherModel, (Object)pair.getRight());
            }
            return pair;
        }

        private final class RFCOverride
        extends ItemOverrideList {
            public RFCOverride() {
                super((List)ImmutableList.of());
            }

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                FluidStack fluid = FoundryItems.item_container.getFluid(stack);
                if (fluid == null || fluid.amount == 0) {
                    return originalModel;
                }
                int y = fluid.amount * 10 / 1000;
                if (y <= 0) {
                    return originalModel;
                }
                ResourceLocation texture = fluid.getFluid().getStill();
                if (texture == null) {
                    texture = TextureMap.field_174945_f;
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.addAll((Iterable)originalModel.func_188616_a(null, null, 0L));
                builder.addAll(RFCModel.getQuadsForSpriteSlice(1, (TextureAtlasSprite)BakedItemModel.this.bakedTextureGetter.apply((Object)texture), BakedItemModel.this.format, 4, 3, 12, 3 + y, fluid.getFluid().getColor(), (Optional<TRSRTransformation>)BakedItemModel.this.transform));
                return new SimpleBakedModel((ImmutableList<BakedQuad>)builder.build(), BakedItemModel.this.particle, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)BakedItemModel.this.transforms);
            }
        }
    }
}

