/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.material;

import exter.foundry.api.material.IMaterialRegistry;
import exter.foundry.util.hashstack.HashableItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public final class MaterialRegistry
implements IMaterialRegistry {
    private HashMap<HashableItem, String> materials = new HashMap();
    private HashMap<HashableItem, String> types = new HashMap();
    private Set<String> material_names = new HashSet<String>();
    private Set<String> type_names = new HashSet<String>();
    public static MaterialRegistry instance = new MaterialRegistry();
    @SideOnly(value=Side.CLIENT)
    private Map<String, ItemStack> material_icons;
    @SideOnly(value=Side.CLIENT)
    private Map<String, ItemStack> type_icons;

    private MaterialRegistry() {
    }

    public void initIcons() {
        this.material_icons = new HashMap<String, ItemStack>();
        this.type_icons = new HashMap<String, ItemStack>();
    }

    @Override
    public void registerItem(String oredict_name, String material, String type) {
        for (ItemStack item : OreDictionary.getOres((String)oredict_name)) {
            this.registerItem(item, material, type);
        }
    }

    @Override
    public void registerItem(ItemStack item, String material, String type) {
        HashableItem hs = new HashableItem(item);
        this.materials.put(hs, material);
        this.types.put(hs, type);
        this.material_names.add(material);
        this.type_names.add(type);
    }

    @Override
    public String getMaterial(ItemStack item) {
        return HashableItem.getFromMap(this.materials, item);
    }

    @Override
    public String getType(ItemStack item) {
        return HashableItem.getFromMap(this.types, item);
    }

    @Override
    public Set<String> getMaterialNames() {
        return Collections.unmodifiableSet(this.material_names);
    }

    @Override
    public Set<String> getTypeNames() {
        return Collections.unmodifiableSet(this.type_names);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerMaterialIcon(String material, ItemStack icon) {
        this.material_icons.put(material, icon);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTypeIcon(String type, ItemStack icon) {
        this.type_icons.put(type, icon);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getMaterialIcon(String material) {
        return this.material_icons.get(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getTypeIcon(String type) {
        return this.type_icons.get(type);
    }
}

