/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.item.firearm;

import exter.foundry.api.FoundryAPI;
import exter.foundry.api.firearms.IFirearmRound;
import exter.foundry.creativetab.FoundryTabFirearms;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.tuple.MutablePair;

public abstract class ItemFirearm
extends Item {
    private static Random random = new Random();

    public ItemFirearm() {
        this.func_77656_e(800);
        this.func_77637_a(FoundryTabFirearms.tab);
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static RayTraceResult trace(World world, EntityLivingBase shooter, Entity target, float spread) {
        Vec3d dir;
        Vec3d start = new Vec3d(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1, shooter.field_70161_v);
        if (target != null) {
            dir = new Vec3d(target.field_70165_t - start.field_72450_a, target.field_70163_u - start.field_72448_b, target.field_70161_v - start.field_72449_c).func_72432_b();
        } else {
            float pitch = -shooter.field_70125_A;
            float yaw = -shooter.field_70177_z;
            float cyaw = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float syaw = MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float cpitch = -MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
            dir = new Vec3d((double)(syaw * cpitch), (double)MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180))), (double)(cyaw * cpitch));
        }
        Vec3d vspread = new Vec3d((double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f)).func_72432_b();
        spread = random.nextFloat() * spread;
        dir = dir.func_72441_c(vspread.field_72450_a * (double)spread, vspread.field_72448_b * (double)spread, vspread.field_72449_c * (double)spread).func_72432_b();
        double distance = 150.0;
        Vec3d end = start.func_72441_c(dir.field_72450_a * distance, dir.field_72448_b * distance, dir.field_72449_c * distance);
        Vec3d tstart = new Vec3d(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        Vec3d tend = new Vec3d(end.field_72450_a, end.field_72448_b, end.field_72449_c);
        RayTraceResult obj = world.func_147447_a(tstart, tend, false, true, false);
        List entities = world.func_72839_b((Entity)shooter, shooter.func_174813_aQ().func_72314_b(150.0, 150.0, 150.0));
        double min_dist = obj != null ? obj.field_72307_f.func_72438_d(start) : 150.0;
        for (Entity ent : entities) {
            RayTraceResult ent_obj;
            if (!ent.func_70067_L() || ent.func_174813_aQ() == null || (ent_obj = ent.func_174813_aQ().func_72314_b(0.1, 0.1, 0.1).func_72327_a(start, end)) == null) continue;
            if (ent_obj.field_72313_a == RayTraceResult.Type.BLOCK) {
                ent_obj.field_72313_a = RayTraceResult.Type.ENTITY;
                ent_obj.field_72308_g = ent;
            }
            double d = ent_obj.field_72307_f.func_72438_d(start);
            if (obj != null && !(d < min_dist)) continue;
            min_dist = d;
            obj = ent_obj;
        }
        if (obj != null) {
            obj.hitInfo = start;
        }
        return obj;
    }

    public static final void shoot(ItemStack round_item, World world, EntityLivingBase shooter, Entity target, int times, float spread, float damage_multiplier) {
        HashMap<EntityLivingBase, MutablePair> entities_hit = new HashMap<EntityLivingBase, MutablePair>();
        IFirearmRound round = (IFirearmRound)round_item.getCapability(FoundryAPI.capability_firearmround, null);
        block4: for (int i = 0; i < times; ++i) {
            RayTraceResult obj = ItemFirearm.trace(world, shooter, target, spread);
            if (obj == null) continue;
            switch (obj.field_72313_a) {
                case BLOCK: {
                    IBlockState b = world.func_180495_p(obj.func_178782_a());
                    if (round.breaksGlass() && b.func_185904_a() == Material.field_151592_s && (double)b.func_185887_b(world, obj.func_178782_a()) < 0.4) {
                        world.func_180498_a(null, 2001, obj.func_178782_a(), Block.func_149682_b((Block)b.func_177230_c()) + (b.func_177230_c().func_176201_c(b) << 12));
                        if (world.field_72995_K) continue block4;
                        world.func_175698_g(obj.func_178782_a());
                        continue block4;
                    }
                    round.onBulletHitBlock(shooter, (Vec3d)obj.hitInfo, world, obj.func_178782_a(), obj.field_178784_b);
                    continue block4;
                }
                case ENTITY: {
                    if (!(obj.field_72308_g instanceof EntityLivingBase)) continue block4;
                    Vec3d end = new Vec3d(obj.field_72308_g.field_70165_t, obj.field_72308_g.field_70163_u, obj.field_72308_g.field_70161_v);
                    double distance = end.func_72438_d((Vec3d)obj.hitInfo);
                    double base_range = round.getBaseRange();
                    double falloff_range = round.getFalloffRange();
                    double base_damage = round.getBaseDamage((EntityLivingBase)obj.field_72308_g);
                    double damage = distance < base_range ? base_damage : (distance > base_range + falloff_range ? 0.0 : base_damage * (1.0 - (distance - base_range) / falloff_range));
                    if (!((damage *= (double)damage_multiplier) >= 1.0)) continue block4;
                    MutablePair accum = (MutablePair)entities_hit.get(obj.field_72308_g);
                    if (accum == null) {
                        accum = new MutablePair((Object)Float.valueOf(0.0f), (Object)0);
                        entities_hit.put((EntityLivingBase)obj.field_72308_g, accum);
                    }
                    MutablePair mutablePair = accum;
                    Float.valueOf(((Float)mutablePair.left).floatValue() + (float)damage);
                    mutablePair.left = mutablePair.left;
                    mutablePair = accum;
                    Integer n = (Integer)mutablePair.right;
                    mutablePair.right = (Integer)mutablePair.right + 1;
                    Integer n2 = mutablePair.right;
                    continue block4;
                }
            }
        }
        for (Map.Entry hit : entities_hit.entrySet()) {
            EntityLivingBase en = (EntityLivingBase)hit.getKey();
            DamageSource damage = new EntityDamageSource("foundry.bullet", (Entity)shooter).func_76349_b();
            if (round.ignoresArmor()) {
                damage.func_76348_h();
            }
            if (!en.func_70097_a(damage, ((Float)((MutablePair)hit.getValue()).left).floatValue())) continue;
            round.onBulletDamagedLivingEntity(en, (Integer)((MutablePair)hit.getValue()).right);
        }
    }

    public final int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public final int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public final EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.BOW;
    }

    public abstract void setAmmo(ItemStack var1, int var2, ItemStack var3);

    public abstract ItemStack getAmmo(ItemStack var1, int var2);

    public static boolean roundMatches(ItemStack stack, String type) {
        if (stack == null) {
            return false;
        }
        if (!stack.hasCapability(FoundryAPI.capability_firearmround, null)) {
            return false;
        }
        return ((IFirearmRound)stack.getCapability(FoundryAPI.capability_firearmround, null)).getRoundType().equals(type);
    }
}

