/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.item;

import exter.foundry.creativetab.FoundryTabFluids;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRefractoryFluidContainer
extends Item {
    public ItemRefractoryFluidContainer() {
        this.func_77637_a(FoundryTabFluids.tab);
        this.func_77625_d(1);
        this.func_77655_b("foundry.fluidContainer");
        this.setRegistryName("fluidContainer");
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getEntityPlayer().func_184586_b(event.getHand());
        if (stack != null && stack.func_77973_b() == this) {
            event.setCanceled(true);
        }
    }

    private void setFluid(ItemStack is, FluidStack fluid) {
        if (fluid != null) {
            NBTTagCompound tag = is.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                is.func_77982_d(tag);
            }
            fluid.writeToNBT(tag);
        } else {
            is.func_77982_d(null);
        }
    }

    private ItemStack fromFluidStack(FluidStack fluid) {
        ItemStack stack = new ItemStack((Item)this, 1, 0);
        if (fluid == null) {
            return stack;
        }
        if (fluid.amount > 1000) {
            fluid = new FluidStack(fluid, 1000);
        }
        this.setFluid(stack, fluid);
        return stack;
    }

    public FluidStack getFluid(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        list.add(this.fromFluidStack(null));
        Map fluids = FluidRegistry.getRegisteredFluids();
        for (Fluid f : fluids.values()) {
            if (f == null) continue;
            list.add(this.fromFluidStack(new FluidStack(f, 1000)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean par4) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid == null) {
            list.add(TextFormatting.BLUE + "Empty");
        } else {
            list.add(TextFormatting.BLUE + fluid.getLocalizedName());
            list.add(TextFormatting.BLUE + String.valueOf(fluid.amount) + " / " + String.valueOf(1000) + " mB");
        }
    }

    private boolean splitStack(ItemStack stack, EntityPlayer player) {
        if (stack.field_77994_a == 1) {
            return true;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        ItemStack rest_stack = stack.func_77946_l();
        --rest_stack.field_77994_a;
        int slot = player.field_71071_by.func_70447_i();
        if (slot >= 0) {
            player.field_71071_by.func_70299_a(slot, rest_stack);
            player.field_71071_by.func_70296_d();
            stack.field_77994_a = 1;
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        FluidStack fluid = this.getFluid(stack);
        RayTraceResult obj = this.func_77621_a(world, player, fluid == null || fluid.amount == 0);
        if (obj == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (obj.field_72313_a == RayTraceResult.Type.BLOCK) {
            TileEntity tile = world.func_175625_s(obj.func_178782_a());
            if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, obj.field_178784_b)) {
                IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, obj.field_178784_b);
                if (player.func_70093_af()) {
                    FluidStack drained = this.drain(stack, 50, false);
                    if (drained == null || drained.amount == 0) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                    int filled = handler.fill(drained, false);
                    if (filled == 0) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                    drained.amount = filled;
                    this.drain(stack, filled, true);
                    handler.fill(drained, true);
                } else {
                    FluidStack drained = handler.drain(50, false);
                    if (drained == null || drained.amount == 0) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                    int filled = this.fill(stack, drained, false, true);
                    if (filled == 0) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                    if (!this.splitStack(stack, player)) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                    drained.amount = filled;
                    handler.drain(filled, true);
                    this.fill(stack, drained, true, false);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            if (!world.canMineBlockBody(player, obj.func_178782_a())) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            if (player.func_70093_af()) {
                BlockPos pos = obj.func_178782_a().func_177971_a(obj.field_178784_b.func_176730_m());
                if (!player.func_175151_a(pos, obj.field_178784_b, stack)) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
                Material material = world.func_180495_p(pos).func_185904_a();
                if (world.func_175623_d(pos) || !material.func_76220_a()) {
                    FluidStack drained = this.drain(stack, 1000, false);
                    if (drained != null && drained.getFluid().canBePlacedInWorld() && drained.amount == 1000) {
                        Block block;
                        this.drain(stack, 1000, true);
                        if (!world.field_72995_K && !material.func_76224_d()) {
                            world.func_175655_b(pos, true);
                        }
                        if ((block = drained.getFluid().getBlock()) == Blocks.field_150355_j) {
                            block = Blocks.field_150358_i;
                        }
                        if (block == Blocks.field_150353_l) {
                            block = Blocks.field_150356_k;
                        }
                        world.func_175656_a(pos, block.func_176223_P());
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
            } else {
                BlockPos pos = obj.func_178782_a();
                if (!player.func_175151_a(pos, obj.field_178784_b, stack)) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof IFluidBlock) {
                    IFluidBlock fluid_block = (IFluidBlock)state.func_177230_c();
                    if (!fluid_block.canDrain(world, pos)) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                    FluidStack drained = fluid_block.drain(world, pos, false);
                    if (drained == null) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                    int filled = this.fill(stack, drained, false, true);
                    if (filled != drained.amount) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                    if (!this.splitStack(stack, player)) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                    fluid_block.drain(world, pos, true);
                    this.fill(stack, drained, true, false);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
                if (state.func_185904_a() == Material.field_151586_h && Integer.valueOf(0).equals(state.func_177229_b((IProperty)BlockLiquid.field_176367_b))) {
                    FluidStack fill = new FluidStack(FluidRegistry.WATER, 1000);
                    if (this.fill(stack, fill, false, true) == 1000) {
                        if (!this.splitStack(stack, player)) {
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                        }
                        this.fill(stack, fill, true, false);
                        world.func_175698_g(pos);
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
                if (state.func_185904_a() == Material.field_151587_i && Integer.valueOf(0).equals(state.func_177229_b((IProperty)BlockLiquid.field_176367_b))) {
                    FluidStack fill = new FluidStack(FluidRegistry.LAVA, 1000);
                    if (this.fill(stack, fill, false, true) == 1000) {
                        if (!this.splitStack(stack, player)) {
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                        }
                        this.fill(stack, fill, true, false);
                        world.func_175698_g(pos);
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public FluidStack drain(ItemStack stack, int amount, boolean doDrain) {
        if (stack.field_77994_a > 1) {
            return null;
        }
        FluidStack fluid = this.getFluid(stack);
        if (fluid == null) {
            return null;
        }
        int drained = amount;
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack drain_fluid = new FluidStack(fluid, drained);
        if (doDrain) {
            fluid.amount -= drained;
            if (fluid.amount <= 0) {
                fluid = null;
            }
            this.setFluid(stack, fluid);
        }
        return drain_fluid;
    }

    private int fill(ItemStack stack, FluidStack fluid, boolean do_fill, boolean ignore_stacksize) {
        if (!ignore_stacksize && stack.field_77994_a > 1) {
            return 0;
        }
        FluidStack container_fluid = this.getFluid(stack);
        if (!do_fill) {
            if (container_fluid == null) {
                return Math.min(1000, fluid.amount);
            }
            if (!container_fluid.isFluidEqual(fluid)) {
                return 0;
            }
            return Math.min(1000 - container_fluid.amount, fluid.amount);
        }
        if (container_fluid == null) {
            container_fluid = new FluidStack(fluid, Math.min(1000, fluid.amount));
            this.setFluid(stack, container_fluid);
            return container_fluid.amount;
        }
        if (!container_fluid.isFluidEqual(fluid)) {
            return 0;
        }
        int filled = 1000 - container_fluid.amount;
        if (fluid.amount < filled) {
            container_fluid.amount += fluid.amount;
            filled = fluid.amount;
        } else {
            container_fluid.amount = 1000;
        }
        this.setFluid(stack, container_fluid);
        return filled;
    }

    public int getItemStackLimit(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid == null) {
            return 16;
        }
        return 1;
    }

    public ItemStack empty(int stack_size) {
        ItemStack stack = new ItemStack((Item)this, stack_size, 0);
        this.setFluid(stack, null);
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandler(stack);
    }

    private class FluidHandler
    implements IFluidHandler,
    IFluidTankProperties,
    ICapabilityProvider {
        private IFluidTankProperties[] props;
        private ItemStack stack;

        public FluidHandler(ItemStack stack) {
            this.stack = stack;
            this.props = new IFluidTankProperties[]{this};
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.props;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return ItemRefractoryFluidContainer.this.fill(this.stack, resource, doFill, false);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack fluid = ItemRefractoryFluidContainer.this.getFluid(this.stack);
            if (resource == null || fluid != null && !fluid.isFluidEqual(resource)) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int amount, boolean doDrain) {
            return ItemRefractoryFluidContainer.this.drain(this.stack, amount, doDrain);
        }

        public FluidStack getContents() {
            if (this.stack.func_77978_p() == null) {
                return null;
            }
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)this.stack.func_77978_p());
        }

        public int getCapacity() {
            return 1000;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
            }
            return null;
        }
    }
}

