/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.minetweaker.orestack;

import exter.foundry.api.recipe.matcher.OreMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientOr;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import net.minecraft.item.ItemStack;

public class MTOreStack
implements IIngredient {
    private final OreMatcher stack;

    public MTOreStack(OreMatcher stack) {
        this.stack = stack;
    }

    public IIngredient amount(int amount) {
        return new MTOreStack(new OreMatcher(this.stack.getOreName(), this.stack.getAmount() * amount));
    }

    public IItemStack applyTransform(IItemStack arg0, IPlayer arg1) {
        return null;
    }

    public boolean contains(IIngredient ingredient) {
        List items = ingredient.getItems();
        for (IItemStack item : items) {
            if (this.matches(item)) continue;
            return false;
        }
        return true;
    }

    public int getAmount() {
        return this.stack.getAmount();
    }

    public Object getInternal() {
        return this.stack;
    }

    public List<IItemStack> getItems() {
        ArrayList<IItemStack> result = new ArrayList<IItemStack>();
        for (ItemStack item : this.stack.getItems()) {
            result.add(MineTweakerMC.getIItemStack((ItemStack)item));
        }
        return result;
    }

    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    public String getMark() {
        return null;
    }

    public boolean hasTransformers() {
        return false;
    }

    public IIngredient marked(String arg0) {
        return this;
    }

    public boolean matches(IItemStack iitem) {
        ItemStack item = MineTweakerMC.getItemStack((IItemStack)iitem);
        return this.stack.apply(item);
    }

    public boolean matches(ILiquidStack arg0) {
        return false;
    }

    public IIngredient only(IItemCondition arg0) {
        return this;
    }

    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr((IIngredient)this, ingredient);
    }

    public IIngredient transform(IItemTransformer arg0) {
        return this;
    }
}

