/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.minetweaker;

import exter.foundry.api.recipe.IMoldRecipe;
import exter.foundry.integration.minetweaker.AddRemoveAction;
import exter.foundry.integration.minetweaker.MTHelper;
import exter.foundry.recipes.MoldRecipe;
import exter.foundry.recipes.manager.MoldRecipeManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.MoldStation")
public class MTMoldStationHandler {
    @ZenMethod
    public static void addRecipe(IItemStack output, int width, int height, int[] grid) {
        MoldRecipe recipe = null;
        try {
            recipe = new MoldRecipe(MineTweakerMC.getItemStack((IItemStack)output), width, height, grid);
        }
        catch (IllegalArgumentException e) {
            MineTweakerAPI.logError((String)("Invalid mold station recipe: " + e.getMessage()));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new MoldStationAction((IMoldRecipe)recipe).action_add);
    }

    @ZenMethod
    public static void removeRecipe(int[] grid) {
        if (grid.length != 36) {
            MineTweakerAPI.logWarning((String)("Invalid mold station grid size: expected 36 instead of " + grid.length));
            return;
        }
        IMoldRecipe recipe = MoldRecipeManager.instance.findRecipe(grid);
        if (recipe == null) {
            MineTweakerAPI.logWarning((String)"Mold station recipe not found.");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new MoldStationAction((IMoldRecipe)recipe).action_remove);
    }

    public static class MoldStationAction
    extends AddRemoveAction {
        IMoldRecipe recipe;

        public MoldStationAction(IMoldRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            MoldRecipeManager.instance.recipes.add(this.recipe);
        }

        @Override
        protected void remove() {
            MoldRecipeManager.instance.recipes.remove(this.recipe);
        }

        @Override
        public String getRecipeType() {
            return "mold station";
        }

        @Override
        public String getDescription() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("( %d, %d, [", this.recipe.getWidth(), this.recipe.getHeight()));
            boolean comma = false;
            for (int r : this.recipe.getRecipeGrid()) {
                if (comma) {
                    builder.append(',');
                }
                builder.append(String.format(" %d", r));
                comma = true;
            }
            builder.append(String.format("] ) -> %s", MTHelper.getItemDescription(this.recipe.getOutput())));
            return builder.toString();
        }
    }
}

