/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.minetweaker;

import exter.foundry.api.recipe.IMeltingRecipe;
import exter.foundry.integration.minetweaker.AddRemoveAction;
import exter.foundry.integration.minetweaker.MTHelper;
import exter.foundry.recipes.MeltingRecipe;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.Melting")
public class MTMeltingHandler {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, IIngredient input, @Optional int melting_point, @Optional int speed) {
        if (melting_point == 0) {
            melting_point = output.getTemperature();
        }
        if (speed == 0) {
            speed = 100;
        }
        MeltingRecipe recipe = null;
        try {
            recipe = new MeltingRecipe(MTHelper.getIngredient(input), MineTweakerMC.getLiquidStack((ILiquidStack)output), melting_point, speed);
        }
        catch (IllegalArgumentException e) {
            MineTweakerAPI.logError((String)"Invalid melting recipe.");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new MeltingAction((IMeltingRecipe)recipe).action_add);
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        IMeltingRecipe recipe = MeltingRecipeManager.instance.findRecipe(MineTweakerMC.getItemStack((IItemStack)input));
        if (recipe == null) {
            MineTweakerAPI.logWarning((String)"Melting recipe not found.");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new MeltingAction((IMeltingRecipe)recipe).action_remove);
    }

    public static class MeltingAction
    extends AddRemoveAction {
        IMeltingRecipe recipe;

        public MeltingAction(IMeltingRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            MeltingRecipeManager.instance.recipes.add(this.recipe);
        }

        @Override
        protected void remove() {
            MeltingRecipeManager.instance.recipes.remove(this.recipe);
        }

        @Override
        public String getRecipeType() {
            return "melting";
        }

        @Override
        public String getDescription() {
            return String.format(" %s -> %s", MTHelper.getItemDescription(this.recipe.getInput()), MTHelper.getFluidDescription(this.recipe.getOutput()));
        }
    }
}

