/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.minetweaker;

import exter.foundry.api.recipe.IInfuserRecipe;
import exter.foundry.integration.minetweaker.AddRemoveAction;
import exter.foundry.integration.minetweaker.MTHelper;
import exter.foundry.recipes.InfuserRecipe;
import exter.foundry.recipes.manager.InfuserRecipeManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.Infuser")
public class MTInfuserHandler {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack input, IIngredient substance, int energy) {
        InfuserRecipe recipe = null;
        try {
            recipe = new InfuserRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)output), MineTweakerMC.getLiquidStack((ILiquidStack)input), MTHelper.getIngredient(substance), energy);
        }
        catch (IllegalArgumentException e) {
            MineTweakerAPI.logError((String)("Invalid infuser recipe: " + e.getMessage()));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new InfuserAction((IInfuserRecipe)recipe).action_add);
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack input, IItemStack substance) {
        IInfuserRecipe recipe = InfuserRecipeManager.instance.findRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)input), MineTweakerMC.getItemStack((IItemStack)substance));
        if (recipe == null) {
            MineTweakerAPI.logWarning((String)"Infuser recipe not found.");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new InfuserAction((IInfuserRecipe)recipe).action_remove);
    }

    public static class InfuserAction
    extends AddRemoveAction {
        IInfuserRecipe recipe;

        public InfuserAction(IInfuserRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            InfuserRecipeManager.instance.recipes.add(this.recipe);
        }

        @Override
        protected void remove() {
            InfuserRecipeManager.instance.recipes.remove(this.recipe);
        }

        @Override
        public String getRecipeType() {
            return "infuser";
        }

        @Override
        public String getDescription() {
            return String.format("( %s, %s ) -> %s", MTHelper.getFluidDescription(this.recipe.getInputFluid()), MTHelper.getItemDescription(this.recipe.getInput()), MTHelper.getFluidDescription(this.recipe.getOutput()));
        }
    }
}

