/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.minetweaker;

import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.integration.minetweaker.AddRemoveAction;
import exter.foundry.integration.minetweaker.MTHelper;
import exter.foundry.recipes.CastingRecipe;
import exter.foundry.recipes.manager.CastingRecipeManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.Casting")
public class MTCastingHandler {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack input, IItemStack mold, @Optional IIngredient extra, @Optional int speed) {
        if (speed == 0) {
            speed = 100;
        }
        CastingRecipe recipe = null;
        try {
            recipe = new CastingRecipe(new ItemStackMatcher(MineTweakerMC.getItemStack((IItemStack)output)), MineTweakerMC.getLiquidStack((ILiquidStack)input), MineTweakerMC.getItemStack((IItemStack)mold), MTHelper.getIngredient(extra), speed);
        }
        catch (IllegalArgumentException e) {
            MineTweakerAPI.logError((String)("Invalid casting recipe: " + e.getMessage()));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new CastingAction((ICastingRecipe)recipe).action_add);
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack input, IItemStack mold, @Optional IItemStack extra) {
        ICastingRecipe recipe = CastingRecipeManager.instance.findRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)input), MineTweakerMC.getItemStack((IItemStack)mold), MineTweakerMC.getItemStack((IItemStack)extra));
        if (recipe == null) {
            MineTweakerAPI.logWarning((String)"Casting recipe not found.");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new CastingAction((ICastingRecipe)recipe).action_remove);
    }

    @ZenMethod
    public static void addMold(IItemStack mold) {
        ItemStack molditem = MineTweakerMC.getItemStack((IItemStack)mold);
        if (molditem == null) {
            MineTweakerAPI.logError((String)"Invalid mold item");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new MoldAction((ItemStack)molditem).action_add);
    }

    @ZenMethod
    public static void removeMold(IItemStack mold) {
        ItemStack molditem = MineTweakerMC.getItemStack((IItemStack)mold);
        if (molditem == null) {
            MineTweakerAPI.logWarning((String)"Invalid mold item");
            return;
        }
        for (ItemStack m : CastingRecipeManager.instance.molds) {
            if (!m.func_77969_a(molditem) || !ItemStack.func_77989_b((ItemStack)m, (ItemStack)molditem)) continue;
            MineTweakerAPI.apply((IUndoableAction)new MoldAction((ItemStack)m).action_remove);
            return;
        }
        MineTweakerAPI.logWarning((String)"Mold not found.");
    }

    public static class MoldAction
    extends AddRemoveAction {
        ItemStack mold;

        public MoldAction(ItemStack mold) {
            this.mold = mold;
        }

        @Override
        protected void add() {
            CastingRecipeManager.instance.molds.add(this.mold);
        }

        @Override
        protected void remove() {
            CastingRecipeManager.instance.molds.remove(this.mold);
        }

        @Override
        public String getRecipeType() {
            return "casting mold";
        }

        @Override
        public String getDescription() {
            return String.format("%s", MTHelper.getItemDescription(this.mold));
        }
    }

    public static class CastingAction
    extends AddRemoveAction {
        ICastingRecipe recipe;

        public CastingAction(ICastingRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            if (this.recipe.requiresExtra()) {
                CastingRecipeManager.instance.recipes.add(0, this.recipe);
            } else {
                CastingRecipeManager.instance.recipes.add(this.recipe);
            }
        }

        @Override
        protected void remove() {
            CastingRecipeManager.instance.recipes.remove(this.recipe);
        }

        @Override
        public String getRecipeType() {
            return "casting";
        }

        @Override
        public String getDescription() {
            IItemMatcher extra = this.recipe.getInputExtra();
            if (extra == null) {
                return String.format("( %s, %s ) -> %s", MTHelper.getFluidDescription(this.recipe.getInput()), MTHelper.getItemDescription(this.recipe.getMold()), MTHelper.getItemDescription(this.recipe.getOutput()));
            }
            return String.format("( %s, %s, %s ) -> %s", MTHelper.getFluidDescription(this.recipe.getInput()), MTHelper.getItemDescription(this.recipe.getMold()), MTHelper.getItemDescription(this.recipe.getInputExtra()), MTHelper.getItemDescription(this.recipe.getOutput()));
        }
    }
}

