/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.minetweaker;

import exter.foundry.api.recipe.IAtomizerRecipe;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.integration.minetweaker.AddRemoveAction;
import exter.foundry.integration.minetweaker.MTHelper;
import exter.foundry.recipes.AtomizerRecipe;
import exter.foundry.recipes.manager.AtomizerRecipeManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.Atomizer")
public class MTAtomizerHandler {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack input) {
        AtomizerRecipe recipe = null;
        try {
            recipe = new AtomizerRecipe(new ItemStackMatcher(MineTweakerMC.getItemStack((IItemStack)output)), MineTweakerMC.getLiquidStack((ILiquidStack)input));
        }
        catch (IllegalArgumentException e) {
            MineTweakerAPI.logError((String)("Invalid atomizer recipe: " + e.getMessage()));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AtomizerAction((IAtomizerRecipe)recipe).action_add);
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack input) {
        IAtomizerRecipe recipe = AtomizerRecipeManager.instance.findRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)input));
        if (recipe == null) {
            MineTweakerAPI.logWarning((String)"Atomizer recipe not found.");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AtomizerAction((IAtomizerRecipe)recipe).action_remove);
    }

    public static class AtomizerAction
    extends AddRemoveAction {
        IAtomizerRecipe recipe;

        public AtomizerAction(IAtomizerRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            AtomizerRecipeManager.instance.recipes.add(this.recipe);
        }

        @Override
        protected void remove() {
            AtomizerRecipeManager.instance.recipes.remove(this.recipe);
        }

        @Override
        public String getRecipeType() {
            return "atomizer";
        }

        @Override
        public String getDescription() {
            return String.format("%s -> %s", MTHelper.getFluidDescription(this.recipe.getInput()), MTHelper.getItemDescription(this.recipe.getOutput()));
        }
    }
}

