/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.minetweaker;

import exter.foundry.api.recipe.IAlloyMixerRecipe;
import exter.foundry.integration.minetweaker.AddRemoveAction;
import exter.foundry.integration.minetweaker.MTHelper;
import exter.foundry.recipes.AlloyMixerRecipe;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.AlloyMixer")
public class MTAlloyMixerHandler {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack[] inputs) {
        FluidStack out = (FluidStack)output.getInternal();
        FluidStack[] in = new FluidStack[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            in[i] = MineTweakerMC.getLiquidStack((ILiquidStack)inputs[i]);
        }
        AlloyMixerRecipe recipe = null;
        try {
            recipe = new AlloyMixerRecipe(out, in);
        }
        catch (IllegalArgumentException e) {
            MineTweakerAPI.logError((String)("Invalid alloy mixer recipe: " + e.getMessage()));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AlloyMixerAction((IAlloyMixerRecipe)recipe).action_add);
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack[] inputs) {
        FluidStack[] in = new FluidStack[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            in[i] = MineTweakerMC.getLiquidStack((ILiquidStack)inputs[i]);
        }
        IAlloyMixerRecipe recipe = AlloyMixerRecipeManager.instance.findRecipe(in, null);
        if (recipe == null) {
            MineTweakerAPI.logWarning((String)"Alloy mixer recipe not found.");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AlloyMixerAction((IAlloyMixerRecipe)recipe).action_remove);
    }

    public static class AlloyMixerAction
    extends AddRemoveAction {
        IAlloyMixerRecipe recipe;

        public AlloyMixerAction(IAlloyMixerRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            AlloyMixerRecipeManager.instance.recipes.add(this.recipe);
        }

        @Override
        protected void remove() {
            AlloyMixerRecipeManager.instance.recipes.remove(this.recipe);
        }

        @Override
        public String getRecipeType() {
            return "alloy mixer";
        }

        @Override
        public String getDescription() {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            boolean comma = false;
            for (FluidStack input : this.recipe.getInputs()) {
                if (comma) {
                    builder.append(',');
                }
                builder.append(' ');
                builder.append(MTHelper.getFluidDescription(input));
                comma = true;
            }
            builder.append(String.format(" ) -> %s", MTHelper.getFluidDescription(this.recipe.getOutput())));
            return builder.toString();
        }
    }
}

