/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.minetweaker;

import exter.foundry.api.recipe.IAlloyFurnaceRecipe;
import exter.foundry.integration.minetweaker.AddRemoveAction;
import exter.foundry.integration.minetweaker.MTHelper;
import exter.foundry.recipes.AlloyFurnaceRecipe;
import exter.foundry.recipes.manager.AlloyFurnaceRecipeManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.AlloyFurnace")
public class MTAlloyFurnaceHandler {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input_a, IIngredient input_b) {
        AlloyFurnaceRecipe recipe = null;
        try {
            recipe = new AlloyFurnaceRecipe(MineTweakerMC.getItemStack((IItemStack)output), MTHelper.getIngredient(input_a), MTHelper.getIngredient(input_b));
        }
        catch (IllegalArgumentException e) {
            MineTweakerAPI.logError((String)("Invalid alloy furnace recipe: " + e.getMessage()));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AlloyFurnaceAction((IAlloyFurnaceRecipe)recipe).action_add);
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input_a, IItemStack input_b) {
        IAlloyFurnaceRecipe recipe = AlloyFurnaceRecipeManager.instance.findRecipe(MineTweakerMC.getItemStack((IItemStack)input_a), MineTweakerMC.getItemStack((IItemStack)input_b));
        if (recipe == null) {
            MineTweakerAPI.logWarning((String)"Alloy furnace recipe not found.");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AlloyFurnaceAction((IAlloyFurnaceRecipe)recipe).action_remove);
    }

    public static class AlloyFurnaceAction
    extends AddRemoveAction {
        IAlloyFurnaceRecipe recipe;

        public AlloyFurnaceAction(IAlloyFurnaceRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            AlloyFurnaceRecipeManager.instance.recipes.add(this.recipe);
        }

        @Override
        protected void remove() {
            AlloyFurnaceRecipeManager.instance.recipes.remove(this.recipe);
        }

        @Override
        public String getRecipeType() {
            return "alloy furnace";
        }

        @Override
        public String getDescription() {
            return String.format(" ( %s, %s ) -> %s", MTHelper.getItemDescription(this.recipe.getInputA()), MTHelper.getItemDescription(this.recipe.getInputB()), MTHelper.getItemDescription(this.recipe.getOutput()));
        }
    }
}

