/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import exter.foundry.api.recipe.IMoldRecipe;
import exter.foundry.recipes.manager.MoldRecipeManager;
import exter.foundry.util.FoundryMiscUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class MoldStationJEI {
    public static List<Wrapper> getRecipes(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        IDrawable[] carve_drawables = new IDrawable[4];
        ResourceLocation location = new ResourceLocation("foundry", "textures/gui/moldstation.png");
        for (int i = 0; i < 4; ++i) {
            carve_drawables[i] = guiHelper.createDrawable(location, 176, 107 + i * 11, 11, 11);
        }
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        for (IMoldRecipe recipe : MoldRecipeManager.instance.getRecipes()) {
            recipes.add(new Wrapper(carve_drawables, recipe.getOutput(), recipe.getWidth(), recipe.getHeight(), recipe.getRecipeGrid()));
        }
        return recipes;
    }

    public static class Handler
    implements IRecipeHandler<Wrapper> {
        @Nonnull
        public Class<Wrapper> getRecipeClass() {
            return Wrapper.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            return "foundry.mold";
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull Wrapper recipe) {
            return recipe;
        }

        public boolean isRecipeValid(@Nonnull Wrapper recipe) {
            return true;
        }

        public String getRecipeCategoryUid(Wrapper recipe) {
            return "foundry.mold";
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation background_location;
        @Nonnull
        protected final IDrawableAnimated arrow;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable grid_drawable;
        private IJeiHelpers helpers;

        public Category(IJeiHelpers helpers) {
            this.helpers = helpers;
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.background_location = new ResourceLocation("foundry", "textures/gui/moldstation.png");
            this.grid_drawable = guiHelper.createDrawable(this.background_location, 176, 31, 76, 76);
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.background_location, 176, 14, 24, 17);
            this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/moldstation.png");
            this.background = guiHelper.createDrawable(location, 36, 14, 133, 81);
            this.localizedName = Translator.translateToLocal((String)"gui.jei.mold");
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public void drawExtras(Minecraft minecraft) {
            this.grid_drawable.draw(minecraft, 2, 2);
        }

        public void drawAnimations(Minecraft minecraft) {
            this.arrow.draw(minecraft, 81, 25);
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        @Nonnull
        public String getUid() {
            return "foundry.mold";
        }

        public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull Wrapper recipeWrapper) {
            IGuiItemStackGroup gui_items = recipeLayout.getItemStacks();
            IStackHelper stack_helper = this.helpers.getStackHelper();
            gui_items.init(0, false, 110, 23);
            gui_items.setFromRecipe(0, stack_helper.toItemStackList((Object)recipeWrapper.getOutputs().get(0)));
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        @Nonnull
        private final List<ItemStack> output;
        private final int width;
        private final int height;
        private final int[] recipe;
        private final IDrawable[] carve_drawables;

        public Wrapper(IDrawable[] carve_drawables, @Nonnull ItemStack output, int width, int height, int[] recipe) {
            this.carve_drawables = carve_drawables;
            this.output = Collections.singletonList(output);
            this.width = width;
            this.height = height;
            this.recipe = recipe;
        }

        @Nonnull
        public List<List<ItemStack>> getInputs() {
            return Collections.emptyList();
        }

        @Nonnull
        public List<ItemStack> getOutputs() {
            return this.output;
        }

        public List<FluidStack> getFluidInputs() {
            return Collections.emptyList();
        }

        public List<FluidStack> getFluidOutputs() {
            return Collections.emptyList();
        }

        public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
        }

        public List<String> getTooltipStrings(int mx, int my) {
            if (mx >= 7 && mx < 73 && my >= 7 && my < 73) {
                int x = (mx - 7) / 11 - (3 - FoundryMiscUtils.divCeil(this.width, 2));
                int y = (my - 7) / 11 - (3 - FoundryMiscUtils.divCeil(this.height, 2));
                int depth = 0;
                if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
                    depth = this.recipe[y * this.width + x];
                }
                return Collections.singletonList("Depth: " + depth);
            }
            return null;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int left = 3 - FoundryMiscUtils.divCeil(this.width, 2);
            int top = 3 - FoundryMiscUtils.divCeil(this.height, 2);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int i = this.recipe[y * this.width + x];
                    if (i <= 0) continue;
                    this.carve_drawables[i - 1].draw(minecraft, 7 + (x + left) * 11, 7 + (y + top) * 11);
                }
            }
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

