/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import exter.foundry.api.recipe.IMeltingRecipe;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class MeltingJEI {
    public static List<Wrapper> getRecipes(IJeiHelpers helpers) {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        for (IMeltingRecipe recipe : MeltingRecipeManager.instance.getRecipes()) {
            List<ItemStack> input = recipe.getInput().getItems();
            if (input.isEmpty()) continue;
            recipes.add(new Wrapper(helpers, input, recipe.getOutput(), recipe.getMeltingPoint()));
        }
        return recipes;
    }

    public static class Handler
    implements IRecipeHandler<Wrapper> {
        @Nonnull
        public Class<Wrapper> getRecipeClass() {
            return Wrapper.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            return "foundry.melting";
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull Wrapper recipe) {
            return recipe;
        }

        public boolean isRecipeValid(@Nonnull Wrapper recipe) {
            return true;
        }

        public String getRecipeCategoryUid(Wrapper recipe) {
            return "foundry.melting";
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation backgroundLocation;
        @Nonnull
        protected final IDrawableAnimated arrow;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable tank_overlay;
        private final IJeiHelpers helpers;

        public Category(IJeiHelpers helpers) {
            this.helpers = helpers;
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.backgroundLocation = new ResourceLocation("foundry", "textures/gui/crucible.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.backgroundLocation, 176, 78, 24, 17);
            this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/crucible.png");
            this.background = guiHelper.createDrawable(location, 30, 16, 94, 54);
            this.tank_overlay = guiHelper.createDrawable(location, 176, 0, 16, 47);
            this.localizedName = Translator.translateToLocal((String)"gui.jei.melting");
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public void drawExtras(Minecraft minecraft) {
        }

        public void drawAnimations(Minecraft minecraft) {
            this.arrow.draw(minecraft, 49, 7);
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        @Nonnull
        public String getUid() {
            return "foundry.melting";
        }

        public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull Wrapper recipeWrapper) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
            guiItemStacks.init(0, true, 24, 6);
            guiFluidStacks.init(1, false, 77, 6, 16, 47, 6000, false, this.tank_overlay);
            guiItemStacks.setFromRecipe(0, this.helpers.getStackHelper().toItemStackList(recipeWrapper.getInputs().get(0)));
            guiFluidStacks.set(1, recipeWrapper.getFluidOutputs().get(0));
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        @Nonnull
        private final List<List<ItemStack>> input;
        @Nonnull
        private final List<FluidStack> output;
        @Nonnull
        private final IDrawable heat;
        private final int melting_point;

        public Wrapper(IJeiHelpers helpers, @Nonnull List<ItemStack> input, FluidStack output, int melting_point) {
            this.input = Collections.singletonList(input);
            this.output = Collections.singletonList(output);
            this.melting_point = melting_point;
            ResourceLocation background_location = new ResourceLocation("foundry", "textures/gui/crucible.png");
            this.heat = helpers.getGuiHelper().createDrawable(background_location, 176, 53, (melting_point * 100 - 29000) * 54 / 471000, 12);
        }

        @Nonnull
        public List<List<ItemStack>> getInputs() {
            return this.input;
        }

        @Nonnull
        public List<ItemStack> getOutputs() {
            return Collections.emptyList();
        }

        public List<FluidStack> getFluidInputs() {
            return Collections.emptyList();
        }

        public List<FluidStack> getFluidOutputs() {
            return this.output;
        }

        public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return null;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            this.heat.draw(minecraft, 11, 41);
            minecraft.field_71466_p.func_78276_b(this.melting_point + " \u00b0K", 14, 28, 0);
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

