/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import exter.foundry.block.BlockFoundryMachine;
import exter.foundry.block.FoundryBlocks;
import exter.foundry.container.ContainerAlloyFurnace;
import exter.foundry.container.ContainerAlloyMixer;
import exter.foundry.container.ContainerMeltingCrucible;
import exter.foundry.container.ContainerMetalAtomizer;
import exter.foundry.container.ContainerMetalCaster;
import exter.foundry.container.ContainerMetalInfuser;
import exter.foundry.container.ContainerMoldStation;
import exter.foundry.integration.jei.AlloyFurnaceJEI;
import exter.foundry.integration.jei.AlloyMixerJEI;
import exter.foundry.integration.jei.AtomizerJEI;
import exter.foundry.integration.jei.CastingJEI;
import exter.foundry.integration.jei.InfuserJEI;
import exter.foundry.integration.jei.MeltingJEI;
import exter.foundry.integration.jei.MoldStationJEI;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEIFoundryPlugin
implements IModPlugin {
    public void register(IModRegistry registry) {
        IJeiHelpers helpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyFurnaceJEI.Category(helpers), new MeltingJEI.Category(helpers), new CastingJEI.Category(helpers), new AlloyMixerJEI.Category(helpers), new InfuserJEI.Category(helpers), new AtomizerJEI.Category(helpers), new MoldStationJEI.Category(helpers)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new AlloyFurnaceJEI.Handler(), new MeltingJEI.Handler(), new CastingJEI.Handler(), new AlloyMixerJEI.Handler(), new InfuserJEI.Handler(), new AtomizerJEI.Handler(), new MoldStationJEI.Handler()});
        IRecipeTransferRegistry transfer_registry = registry.getRecipeTransferRegistry();
        transfer_registry.addRecipeTransferHandler(ContainerAlloyFurnace.class, "foundry.alloyfurnace", 0, 4, 4, 36);
        transfer_registry.addRecipeTransferHandler(ContainerMeltingCrucible.class, "foundry.melting", 0, 3, 3, 36);
        transfer_registry.addRecipeTransferHandler(ContainerMetalCaster.class, "foundry.casting", 0, 14, 14, 36);
        transfer_registry.addRecipeTransferHandler(ContainerAlloyMixer.class, "foundry.alloymixer", 0, 10, 10, 36);
        transfer_registry.addRecipeTransferHandler(ContainerMetalInfuser.class, "foundry.infuser", 0, 5, 5, 36);
        transfer_registry.addRecipeTransferHandler(ContainerMetalAtomizer.class, "foundry.atomizer", 0, 5, 5, 36);
        transfer_registry.addRecipeTransferHandler(ContainerMoldStation.class, "foundry.mold", 0, 4, 4, 36);
        registry.addRecipeCategoryCraftingItem(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.CRUCIBLE), new String[]{"foundry.melting"});
        registry.addRecipeCategoryCraftingItem(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.ADVCRUCIBLE), new String[]{"foundry.melting"});
        registry.addRecipeCategoryCraftingItem(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.CASTER), new String[]{"foundry.casting"});
        registry.addRecipeCategoryCraftingItem(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.ALLOYMIXER), new String[]{"foundry.alloymixer"});
        registry.addRecipeCategoryCraftingItem(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.INFUSER), new String[]{"foundry.infuser"});
        registry.addRecipeCategoryCraftingItem(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.ATOMIZER), new String[]{"foundry.atomizer"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)FoundryBlocks.block_mold_station), new String[]{"foundry.mold"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)FoundryBlocks.block_alloy_furnace), new String[]{"foundry.alloyfurnace"});
        registry.addRecipes(AlloyFurnaceJEI.getRecipes(helpers));
        registry.addRecipes(MeltingJEI.getRecipes(helpers));
        registry.addRecipes(CastingJEI.getRecipes());
        registry.addRecipes(AlloyMixerJEI.getRecipes());
        registry.addRecipes(InfuserJEI.getRecipes());
        registry.addRecipes(AtomizerJEI.getRecipes());
        registry.addRecipes(MoldStationJEI.getRecipes(helpers));
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }
}

