/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import exter.foundry.api.recipe.IInfuserRecipe;
import exter.foundry.recipes.manager.InfuserRecipeManager;
import exter.foundry.tileentity.TileEntityFoundryPowered;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class InfuserJEI {
    public static List<Wrapper> getRecipes() {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        for (IInfuserRecipe recipe : InfuserRecipeManager.instance.getRecipes()) {
            List<ItemStack> input = recipe.getInput().getItems();
            if (input.isEmpty()) continue;
            recipes.add(new Wrapper(recipe.getOutput(), recipe.getInputFluid(), input, recipe.getEnergyNeeded()));
        }
        return recipes;
    }

    public static class Handler
    implements IRecipeHandler<Wrapper> {
        @Nonnull
        public Class<Wrapper> getRecipeClass() {
            return Wrapper.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            return "foundry.infuser";
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull Wrapper recipe) {
            return recipe;
        }

        public boolean isRecipeValid(@Nonnull Wrapper recipe) {
            return true;
        }

        public String getRecipeCategoryUid(Wrapper recipe) {
            return "foundry.infuser";
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation background_location;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable tank_overlay;
        private final IJeiHelpers helpers;
        @Nonnull
        protected final IDrawableAnimated arrow;

        public Category(IJeiHelpers helpers) {
            this.helpers = helpers;
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.background_location = new ResourceLocation("foundry", "textures/gui/infuser.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.background_location, 176, 53, 24, 17);
            this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/infuser.png");
            this.background = guiHelper.createDrawable(location, 15, 41, 137, 51);
            this.tank_overlay = guiHelper.createDrawable(location, 176, 0, 16, 47);
            this.localizedName = Translator.translateToLocal((String)"gui.jei.infuser");
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public void drawExtras(Minecraft minecraft) {
        }

        public void drawAnimations(Minecraft minecraft) {
            this.arrow.draw(minecraft, 34, 18);
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        @Nonnull
        public String getUid() {
            return "foundry.infuser";
        }

        public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull Wrapper recipeWrapper) {
            IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
            guiFluidStacks.init(0, true, 59, 2, 16, 47, 5000, false, this.tank_overlay);
            guiFluidStacks.init(1, false, 108, 2, 16, 47, 5000, false, this.tank_overlay);
            guiFluidStacks.set(0, recipeWrapper.getFluidInputs().get(0));
            guiFluidStacks.set(1, recipeWrapper.getFluidOutputs().get(0));
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            guiItemStacks.init(0, true, 14, 17);
            guiItemStacks.setFromRecipe(0, this.helpers.getStackHelper().toItemStackList(recipeWrapper.getInputs().get(0)));
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        @Nonnull
        private final List<FluidStack> input_fluid;
        @Nonnull
        private final List<FluidStack> output;
        @Nonnull
        private final List<List<ItemStack>> input;
        private final int energy;

        public Wrapper(@Nonnull FluidStack output, @Nonnull FluidStack input_fluid, @Nonnull List<ItemStack> input, int energy) {
            this.input_fluid = Collections.singletonList(input_fluid);
            this.output = Collections.singletonList(output);
            this.input = Collections.singletonList(input);
            this.energy = energy;
        }

        @Nonnull
        public List<List<ItemStack>> getInputs() {
            return this.input;
        }

        @Nonnull
        public List<ItemStack> getOutputs() {
            return Collections.emptyList();
        }

        public List<FluidStack> getFluidInputs() {
            return this.input_fluid;
        }

        public List<FluidStack> getFluidOutputs() {
            return this.output;
        }

        public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
        }

        public List<String> getTooltipStrings(int x, int y) {
            return null;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            minecraft.field_71466_p.func_78276_b(this.energy / TileEntityFoundryPowered.RATIO_RF + " RF", 0, 38, 0);
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

