/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import com.google.common.collect.Lists;
import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.recipes.manager.CastingRecipeManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CastingJEI {
    public static List<Wrapper> getRecipes() {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        for (ICastingRecipe recipe : CastingRecipeManager.instance.getRecipes()) {
            ItemStack output = recipe.getOutput();
            if (output == null) continue;
            IItemMatcher extra = recipe.getInputExtra();
            recipes.add(new Wrapper(output, recipe.getInput(), recipe.getMold(), extra == null ? Collections.emptyList() : extra.getItems()));
        }
        return recipes;
    }

    public static class Handler
    implements IRecipeHandler<Wrapper> {
        @Nonnull
        public Class<Wrapper> getRecipeClass() {
            return Wrapper.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            return "foundry.casting";
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull Wrapper recipe) {
            return recipe;
        }

        public boolean isRecipeValid(@Nonnull Wrapper recipe) {
            return true;
        }

        public String getRecipeCategoryUid(Wrapper recipe) {
            return "foundry.casting";
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation backgroundLocation;
        @Nonnull
        protected final IDrawableAnimated arrow;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable tank_overlay;
        private IJeiHelpers helpers;

        public Category(IJeiHelpers helpers) {
            this.helpers = helpers;
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.backgroundLocation = new ResourceLocation("foundry", "textures/gui/caster.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.backgroundLocation, 176, 53, 24, 17);
            this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/caster.png");
            this.background = guiHelper.createDrawable(location, 38, 16, 68, 54);
            this.tank_overlay = guiHelper.createDrawable(location, 176, 0, 16, 47);
            this.localizedName = Translator.translateToLocal((String)"gui.jei.casting");
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public void drawExtras(Minecraft minecraft) {
        }

        public void drawAnimations(Minecraft minecraft) {
            this.arrow.draw(minecraft, 22, 35);
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        @Nonnull
        public String getUid() {
            return "foundry.casting";
        }

        public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull Wrapper recipeWrapper) {
            IGuiItemStackGroup gui_items = recipeLayout.getItemStacks();
            IGuiFluidStackGroup gui_fluids = recipeLayout.getFluidStacks();
            IStackHelper stack_helper = this.helpers.getStackHelper();
            gui_items.init(0, false, 47, 34);
            gui_items.init(1, true, 27, 4);
            gui_items.init(2, true, 47, 4);
            gui_fluids.init(3, true, 1, 5, 16, 47, 6000, false, this.tank_overlay);
            gui_items.setFromRecipe(0, stack_helper.toItemStackList((Object)recipeWrapper.getOutputs().get(0)));
            gui_items.setFromRecipe(1, stack_helper.toItemStackList(recipeWrapper.getInputs().get(0)));
            gui_items.setFromRecipe(2, stack_helper.toItemStackList(recipeWrapper.getInputs().get(1)));
            gui_fluids.set(3, recipeWrapper.getFluidInputs().get(0));
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        @Nonnull
        private final List<FluidStack> input_fluid;
        @Nonnull
        private final List<ItemStack> output;
        @Nonnull
        private final List<List<ItemStack>> input;

        public Wrapper(@Nonnull ItemStack output, FluidStack input, ItemStack mold, List<ItemStack> extra) {
            this.input_fluid = Collections.singletonList(input);
            this.input = Lists.newArrayList((Object[])new List[]{Collections.singletonList(mold), extra});
            Collections.singletonList(input);
            this.output = Collections.singletonList(output);
        }

        @Nonnull
        public List<List<ItemStack>> getInputs() {
            return this.input;
        }

        @Nonnull
        public List<ItemStack> getOutputs() {
            return this.output;
        }

        public List<FluidStack> getFluidInputs() {
            return this.input_fluid;
        }

        public List<FluidStack> getFluidOutputs() {
            return Collections.emptyList();
        }

        public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return null;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

