/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import com.google.common.collect.Lists;
import exter.foundry.api.recipe.IAtomizerRecipe;
import exter.foundry.recipes.manager.AtomizerRecipeManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class AtomizerJEI {
    public static List<Wrapper> getRecipes() {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        for (IAtomizerRecipe recipe : AtomizerRecipeManager.instance.getRecipes()) {
            ItemStack output = recipe.getOutput();
            if (output == null) continue;
            recipes.add(new Wrapper(output, recipe.getInput()));
        }
        return recipes;
    }

    public static class Handler
    implements IRecipeHandler<Wrapper> {
        @Nonnull
        public Class<Wrapper> getRecipeClass() {
            return Wrapper.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            return "foundry.atomizer";
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull Wrapper recipe) {
            return recipe;
        }

        public boolean isRecipeValid(@Nonnull Wrapper recipe) {
            return true;
        }

        public String getRecipeCategoryUid(Wrapper recipe) {
            return "foundry.atomizer";
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation backgroundLocation;
        @Nonnull
        protected final IDrawableAnimated arrow;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable tank_overlay;
        private final IJeiHelpers helpers;

        public Category(IJeiHelpers helpers) {
            this.helpers = helpers;
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.backgroundLocation = new ResourceLocation("foundry", "textures/gui/atomizer.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.backgroundLocation, 176, 53, 24, 17);
            this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/atomizer.png");
            this.background = guiHelper.createDrawable(location, 8, 19, 133, 51);
            this.tank_overlay = guiHelper.createDrawable(location, 176, 0, 16, 47);
            this.localizedName = Translator.translateToLocal((String)"gui.jei.atomizer");
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public void drawExtras(Minecraft minecraft) {
        }

        public void drawAnimations(Minecraft minecraft) {
            this.arrow.draw(minecraft, 52, 18);
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        @Nonnull
        public String getUid() {
            return "foundry.atomizer";
        }

        public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull Wrapper recipeWrapper) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
            guiItemStacks.init(0, false, 77, 17);
            guiFluidStacks.init(1, true, 31, 2, 16, 47, 6000, false, this.tank_overlay);
            guiFluidStacks.init(2, true, 115, 2, 16, 47, 6000, false, this.tank_overlay);
            guiItemStacks.setFromRecipe(0, this.helpers.getStackHelper().toItemStackList((Object)recipeWrapper.getOutputs().get(0)));
            guiFluidStacks.set(1, recipeWrapper.getFluidInputs().get(0));
            guiFluidStacks.set(2, recipeWrapper.getFluidInputs().get(1));
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        @Nonnull
        private final List<FluidStack> input;
        @Nonnull
        private final List<ItemStack> output;
        private static final FluidStack WATER = new FluidStack(FluidRegistry.WATER, 50);

        public Wrapper(@Nonnull ItemStack output, FluidStack input) {
            this.input = Lists.newArrayList((Object[])new FluidStack[]{input, WATER});
            this.output = Collections.singletonList(output);
        }

        @Nonnull
        public List<List<ItemStack>> getInputs() {
            return Collections.emptyList();
        }

        @Nonnull
        public List<ItemStack> getOutputs() {
            return this.output;
        }

        public List<FluidStack> getFluidInputs() {
            return this.input;
        }

        public List<FluidStack> getFluidOutputs() {
            return Collections.emptyList();
        }

        public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return null;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

