/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import exter.foundry.api.recipe.IAlloyMixerRecipe;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class AlloyMixerJEI {
    public static List<Wrapper> getRecipes() {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        for (IAlloyMixerRecipe recipe : AlloyMixerRecipeManager.instance.getRecipes()) {
            recipes.add(new Wrapper(recipe.getOutput(), recipe.getInputs()));
        }
        return recipes;
    }

    public static class Handler
    implements IRecipeHandler<Wrapper> {
        @Nonnull
        public Class<Wrapper> getRecipeClass() {
            return Wrapper.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            return "foundry.alloymixer";
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull Wrapper recipe) {
            return recipe;
        }

        public boolean isRecipeValid(@Nonnull Wrapper recipe) {
            return true;
        }

        public String getRecipeCategoryUid(Wrapper recipe) {
            return "foundry.alloymixer";
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation backgroundLocation;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable tank_overlay;

        public Category(IJeiHelpers helpers) {
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.backgroundLocation = new ResourceLocation("foundry", "textures/gui/alloymixer.png");
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/alloymixer.png");
            this.background = guiHelper.createDrawable(location, 18, 44, 132, 37);
            this.tank_overlay = guiHelper.createDrawable(location, 176, 0, 16, 35);
            this.localizedName = Translator.translateToLocal((String)"gui.jei.alloymixer");
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public void drawExtras(Minecraft minecraft) {
        }

        public void drawAnimations(Minecraft minecraft) {
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        @Nonnull
        public String getUid() {
            return "foundry.alloymixer";
        }

        public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull Wrapper recipeWrapper) {
            IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
            for (int i = 0; i < recipeWrapper.getFluidInputs().size(); ++i) {
                guiFluidStacks.init(i, true, 8 + 21 * i, 1, 16, 35, recipeWrapper.getFluidInputs().get((int)i).amount, false, this.tank_overlay);
                guiFluidStacks.set(i, recipeWrapper.getFluidInputs().get(i));
            }
            guiFluidStacks.init(5, false, 115, 1, 16, 35, recipeWrapper.getFluidOutputs().get((int)0).amount, false, this.tank_overlay);
            guiFluidStacks.set(5, recipeWrapper.getFluidOutputs().get(0));
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        @Nonnull
        private final List<FluidStack> input;
        @Nonnull
        private final List<FluidStack> output;

        public Wrapper(@Nonnull FluidStack output, List<FluidStack> input) {
            this.input = input;
            this.output = Collections.singletonList(output);
        }

        @Nonnull
        public List<List<ItemStack>> getInputs() {
            return Collections.emptyList();
        }

        @Nonnull
        public List<ItemStack> getOutputs() {
            return Collections.emptyList();
        }

        public List<FluidStack> getFluidInputs() {
            return this.input;
        }

        public List<FluidStack> getFluidOutputs() {
            return this.output;
        }

        public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return null;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

