/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration;

import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.config.FoundryConfig;
import exter.foundry.fluid.FluidLiquidMetal;
import exter.foundry.fluid.LiquidMetalRegistry;
import exter.foundry.integration.IModIntegration;
import exter.foundry.item.FoundryItems;
import exter.foundry.item.ItemMold;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import exter.foundry.recipes.manager.CastingRecipeManager;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import exter.foundry.util.FoundryMiscUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

@Optional.Interface(iface="exter.foundry.integration.IModIntegration", modid="tconstruct")
public class ModIntegrationTiCon
implements IModIntegration {
    private Map<String, String> liquid_map;
    private Map<String, String> reverse_liquid_map;
    private static final int TICON_INGOT_AMOUNT = 144;
    private static final int INGOT_GCD = ModIntegrationTiCon.gcd(144, 108);

    private static final int gcd(int a, int b) {
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public void onPreInit(Configuration config) {
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public void onInit() {
    }

    @Optional.Method(modid="tconstruct")
    private void createAlloyRecipe(AlloyRecipe mix, int index, List<FluidStack> inputs) {
        ArrayList<FluidStack> in;
        if (index == mix.getFluids().size()) {
            FluidStack[] in2 = new FluidStack[mix.getFluids().size()];
            in2 = inputs.toArray(in2);
            FluidStack result = mix.getResult().copy();
            result.amount *= 144 / INGOT_GCD;
            int div = mix.getResult().amount;
            for (FluidStack f : in2) {
                div = ModIntegrationTiCon.gcd(div, f.amount);
            }
            for (FluidStack f : in2) {
                f.amount /= div;
            }
            result.amount /= div;
            AlloyMixerRecipeManager.instance.addRecipe(result, in2);
            return;
        }
        FluidStack ing = (FluidStack)mix.getFluids().get(index);
        String mapped = this.liquid_map.get(ing.getFluid().getName());
        if (mapped != null) {
            in = new ArrayList<FluidStack>(inputs);
            in.add(new FluidStack((Fluid)LiquidMetalRegistry.instance.getFluid(mapped), ing.amount * 108 / INGOT_GCD));
            this.createAlloyRecipe(mix, index + 1, in);
        }
        in = new ArrayList<FluidStack>(inputs);
        FluidStack fl = ing;
        in.add(new FluidStack(fl.getFluid(), fl.amount * 144 / INGOT_GCD));
        this.createAlloyRecipe(mix, index + 1, in);
    }

    @Optional.Method(modid="tconstruct")
    private void createAlloyRecipe(AlloyRecipe mix) {
        if (mix.getFluids().size() > 4) {
            return;
        }
        this.createAlloyRecipe(mix, 0, new ArrayList<FluidStack>());
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public void onPostInit() {
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public void onAfterPostInit() {
        CastingRecipe recipe;
        FluidLiquidMetal fluid;
        String mapped;
        this.liquid_map = new HashMap<String, String>();
        for (String string : LiquidMetalRegistry.instance.getFluidNames()) {
            Object tic_name;
            if (string.equals("Glass")) {
                if (!FoundryConfig.recipe_glass || FluidRegistry.getFluid((String)"glass") == null) continue;
                this.liquid_map.put("glass", "Glass");
                continue;
            }
            if (string.startsWith("Glass") || LiquidMetalRegistry.instance.getFluid((String)string).special || FluidRegistry.getFluid((String)(tic_name = string.toLowerCase())) == null) continue;
            this.liquid_map.put((String)tic_name, string);
        }
        this.reverse_liquid_map = new HashMap<String, String>();
        for (Map.Entry entry : this.liquid_map.entrySet()) {
            this.reverse_liquid_map.put(LiquidMetalRegistry.instance.getFluid((String)entry.getValue()).getName(), (String)entry.getKey());
        }
        for (MeltingRecipe meltingRecipe : TinkerRegistry.getAllMeltingRecipies()) {
            for (ItemStack stack : meltingRecipe.input.getInputs()) {
                if (MeltingRecipeManager.instance.findRecipe(stack) != null) continue;
                FluidStack result = meltingRecipe.output;
                String mapped2 = this.liquid_map.get(result.getFluid().getName());
                if (mapped2 != null) {
                    FluidStack mapped_liquid = mapped2.equals("Glass") ? new FluidStack((Fluid)LiquidMetalRegistry.instance.getFluid(mapped2), result.amount) : new FluidStack((Fluid)LiquidMetalRegistry.instance.getFluid(mapped2), FoundryMiscUtils.divCeil(result.amount * 108, 144));
                    if (mapped_liquid.amount > 6000) continue;
                    MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(stack), mapped_liquid);
                    continue;
                }
                if (result.amount > 6000) continue;
                int temp = meltingRecipe.temperature + 274;
                if (temp < 350) {
                    temp = 350;
                }
                MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(stack), result, temp);
            }
        }
        for (AlloyRecipe alloyRecipe : TinkerRegistry.getAlloys()) {
            String mapped_result = this.liquid_map.get(alloyRecipe.getResult().getFluid().getName());
            if (mapped_result != null) continue;
            this.createAlloyRecipe(alloyRecipe);
        }
        for (CastingRecipe castingRecipe : TinkerRegistry.getAllTableCastingRecipes()) {
            if (castingRecipe.cast == null || castingRecipe.consumesCast() || castingRecipe.getResult() == null) continue;
            String mapped3 = this.liquid_map.get(castingRecipe.getFluid().getFluid().getName());
            FluidStack mapped_liquid = null;
            if (mapped3 != null) {
                mapped_liquid = new FluidStack((Fluid)LiquidMetalRegistry.instance.getFluid(mapped3), FoundryMiscUtils.divCeil(castingRecipe.getFluid().amount * 108, 144));
            }
            for (ItemStack cast : castingRecipe.cast.getInputs()) {
                if (!CastingRecipeManager.instance.isItemMold(cast)) {
                    CastingRecipeManager.instance.addMold(cast);
                }
                if (mapped_liquid != null && mapped_liquid.amount <= 6000) {
                    CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(castingRecipe.getResult()), mapped_liquid, cast, null);
                }
                if (castingRecipe.getFluid().amount > 6000) continue;
                CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(castingRecipe.getResult()), castingRecipe.getFluid(), cast, null);
            }
        }
        ItemStack block_mold = FoundryItems.mold(ItemMold.SubItem.BLOCK);
        for (CastingRecipe casting : TinkerRegistry.getAllBasinCastingRecipes()) {
            if (casting.getResult() == null) continue;
            FluidStack fluid2 = casting.getFluid();
            if (casting.getFluid().amount > 6000 || casting.cast != null || CastingRecipeManager.instance.findRecipe(fluid2, block_mold, null) != null) continue;
            CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(casting.getResult()), fluid2, block_mold, null);
        }
        ArrayList<CastingRecipe> arrayList = new ArrayList<CastingRecipe>();
        for (CastingRecipe casting : TinkerRegistry.getAllTableCastingRecipes()) {
            RecipeMatch.Match bucket_match;
            if (casting.getResult() == null || casting.cast != null && (bucket_match = casting.cast.matches(new ItemStack[]{new ItemStack(Items.field_151133_ar)})) != null && bucket_match.stacks != null && bucket_match.stacks.size() > 0 || (mapped = this.liquid_map.get(casting.getFluid().getFluid().getName())) == null) continue;
            fluid = LiquidMetalRegistry.instance.getFluid(mapped);
            FluidStack mapped_liquid = new FluidStack((Fluid)fluid, mapped.equals("Glass") ? casting.getFluid().amount : FoundryMiscUtils.divCeil(casting.getFluid().amount * 108, 144));
            recipe = new CastingRecipe(casting.getResult(), casting.cast, mapped_liquid, casting.getTime(), casting.consumesCast(), casting.switchOutputs());
            arrayList.add(recipe);
        }
        for (CastingRecipe r : arrayList) {
            TinkerRegistry.registerTableCasting((CastingRecipe)r);
        }
        arrayList.clear();
        for (CastingRecipe casting : TinkerRegistry.getAllBasinCastingRecipes()) {
            if (casting.cast != null || casting.getResult() == null || (mapped = this.liquid_map.get(casting.getFluid().getFluid().getName())) == null) continue;
            fluid = LiquidMetalRegistry.instance.getFluid(mapped);
            FluidStack mapped_liquid = new FluidStack((Fluid)fluid, mapped.equals("Glass") ? casting.getFluid().amount : FoundryMiscUtils.divCeil(casting.getFluid().amount * 108, 144));
            recipe = new CastingRecipe(casting.getResult(), null, mapped_liquid, casting.getTime(), casting.consumesCast(), casting.switchOutputs());
            arrayList.add(recipe);
        }
        for (CastingRecipe r : arrayList) {
            TinkerRegistry.registerBasinCasting((CastingRecipe)r);
        }
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public String getName() {
        return "TiCon";
    }

    @Override
    @Optional.Method(modid="tconstruct")
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
    }

    @Override
    @Optional.Method(modid="tconstruct")
    @SideOnly(value=Side.CLIENT)
    public void onClientInit() {
    }

    @Override
    @Optional.Method(modid="tconstruct")
    @SideOnly(value=Side.CLIENT)
    public void onClientPostInit() {
    }
}

