/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration;

import exter.foundry.api.recipe.IAlloyMixerRecipe;
import exter.foundry.api.recipe.IAtomizerRecipe;
import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.config.FoundryConfig;
import exter.foundry.fluid.FluidLiquidMetal;
import exter.foundry.fluid.LiquidMetalRegistry;
import exter.foundry.integration.IModIntegration;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import exter.foundry.recipes.manager.AtomizerRecipeManager;
import exter.foundry.recipes.manager.CastingRecipeManager;
import exter.foundry.recipes.manager.CastingTableRecipeManager;
import exter.foundry.util.FoundryMiscUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModIntegrationMolten
implements IModIntegration {
    private Map<String, String> liquid_map;
    private static final int MOLTEN_INGOT_AMOUNT = 144;

    private static final int gcd(int a, int b) {
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    @Override
    public void onPreInit(Configuration config) {
    }

    @Override
    public void onInit() {
    }

    private FluidStack toMolten(FluidStack stack) {
        String mapped = this.liquid_map.get(stack.getFluid().getName());
        if (mapped != null) {
            Fluid mapped_fluid = FluidRegistry.getFluid((String)mapped);
            if (mapped.equals("glass")) {
                return new FluidStack(mapped_fluid, stack.amount);
            }
            return new FluidStack(mapped_fluid, FoundryMiscUtils.divCeil(stack.amount * 144, 108));
        }
        return null;
    }

    private void convertAlloyRecipe(IAlloyMixerRecipe mix, int index, List<FluidStack> inputs, boolean has_mapped) {
        ArrayList<FluidStack> in;
        if (index == mix.getInputs().size()) {
            if (!has_mapped) {
                return;
            }
            FluidStack[] in2 = new FluidStack[mix.getInputs().size()];
            for (int i = 0; i < in2.length; ++i) {
                in2[i] = inputs.get(i).copy();
            }
            FluidStack result = mix.getOutput();
            result.amount *= 108;
            int div = result.amount;
            for (FluidStack f : in2) {
                div = ModIntegrationMolten.gcd(div, f.amount);
            }
            for (FluidStack f : in2) {
                f.amount /= div;
            }
            result.amount /= div;
            AlloyMixerRecipeManager.instance.addRecipe(result, in2);
            return;
        }
        FluidStack input = mix.getInputs().get(index).copy();
        input.amount *= 108;
        FluidStack molten = this.toMolten(input);
        if (molten != null) {
            in = new ArrayList<FluidStack>(inputs);
            in.add(molten);
            this.convertAlloyRecipe(mix, index + 1, in, true);
        }
        in = new ArrayList<FluidStack>(inputs);
        in.add(input.copy());
        this.convertAlloyRecipe(mix, index + 1, in, has_mapped);
    }

    private void convertAlloyRecipe(IAlloyMixerRecipe mix) {
        this.convertAlloyRecipe(mix, 0, new ArrayList<FluidStack>(), false);
    }

    @Override
    public void onPostInit() {
    }

    @Override
    public void onAfterPostInit() {
        FluidStack input;
        this.liquid_map = new HashMap<String, String>();
        for (String string : LiquidMetalRegistry.instance.getFluidNames()) {
            String molten_name;
            FluidLiquidMetal fluid = LiquidMetalRegistry.instance.getFluid(string);
            if (string.equals("Glass")) {
                if (!FoundryConfig.recipe_glass || FluidRegistry.getFluid((String)"glass") == null) continue;
                this.liquid_map.put(fluid.getName(), "glass");
                continue;
            }
            if (string.startsWith("Glass") || fluid.special || FluidRegistry.getFluid((String)(molten_name = string.toLowerCase())) == null) continue;
            this.liquid_map.put(fluid.getName(), molten_name);
        }
        for (ICastingRecipe iCastingRecipe : new ArrayList<ICastingRecipe>(CastingRecipeManager.instance.getRecipes())) {
            input = this.toMolten(iCastingRecipe.getInput());
            if (input == null) continue;
            CastingRecipeManager.instance.addRecipe(iCastingRecipe.getOutputMatcher(), input, iCastingRecipe.getMold(), iCastingRecipe.getInputExtra(), iCastingRecipe.getCastingSpeed());
        }
        for (ICastingTableRecipe iCastingTableRecipe : CastingTableRecipeManager.instance.getRecipes()) {
            input = this.toMolten(iCastingTableRecipe.getInput());
            if (input == null) continue;
            CastingTableRecipeManager.instance.addRecipe(iCastingTableRecipe.getOutputMatcher(), input, iCastingTableRecipe.getTableType());
        }
        for (IAtomizerRecipe iAtomizerRecipe : new ArrayList<IAtomizerRecipe>(AtomizerRecipeManager.instance.getRecipes())) {
            input = this.toMolten(iAtomizerRecipe.getInput());
            if (input == null) continue;
            AtomizerRecipeManager.instance.addRecipe(iAtomizerRecipe.getOutputMatcher(), input);
        }
        for (IAlloyMixerRecipe iAlloyMixerRecipe : new ArrayList<IAlloyMixerRecipe>(AlloyMixerRecipeManager.instance.getRecipes())) {
            this.convertAlloyRecipe(iAlloyMixerRecipe);
        }
    }

    @Override
    public String getName() {
        return "MoltenMetalFluids";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPostInit() {
    }
}

