/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration;

import exter.foundry.ModFoundry;
import exter.foundry.config.FoundryConfig;
import exter.foundry.integration.IModIntegration;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModIntegrationManager {
    private static Map<String, IModIntegration> integrations = new HashMap<String, IModIntegration>();

    public static IModIntegration getIntegration(String name) {
        return integrations.get(name);
    }

    public static void registerIntegration(Configuration config, Object mod) {
        if (mod instanceof IModIntegration) {
            IModIntegration imod = (IModIntegration)mod;
            String name = imod.getName();
            boolean enable = FoundryConfig.getAndRemove(config, "integration", "enable." + name, true);
            enable = config.getBoolean("enable", "integration" + name, true, "Enable/disable mod integration.");
            if (enable) {
                integrations.put(name, imod);
            }
        }
    }

    public static void preInit(Configuration config) {
        for (IModIntegration m : integrations.values()) {
            ModFoundry.log.info("PreInit integration: " + m.getName());
            m.onPreInit(config);
        }
    }

    public static void init() {
        for (IModIntegration m : integrations.values()) {
            ModFoundry.log.info("Init integration: " + m.getName());
            m.onInit();
        }
    }

    public static void postInit() {
        for (IModIntegration m : integrations.values()) {
            ModFoundry.log.info("PostInit integration: " + m.getName());
            m.onPostInit();
        }
    }

    public static void afterPostInit() {
        for (IModIntegration m : integrations.values()) {
            ModFoundry.log.info("AfterPostInit integration: " + m.getName());
            m.onAfterPostInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientPreInit() {
        for (IModIntegration m : integrations.values()) {
            m.onClientPreInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientInit() {
        for (IModIntegration m : integrations.values()) {
            m.onClientInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientPostInit() {
        for (IModIntegration m : integrations.values()) {
            m.onClientPostInit();
        }
    }
}

