/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration;

import exter.foundry.api.FoundryUtils;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.config.FoundryConfig;
import exter.foundry.fluid.FoundryFluids;
import exter.foundry.fluid.LiquidMetalRegistry;
import exter.foundry.integration.IModIntegration;
import exter.foundry.item.ItemMold;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import exter.foundry.recipes.manager.InfuserRecipeManager;
import exter.foundry.util.FoundryMiscUtils;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModIntegrationEnderIO
implements IModIntegration {
    private Fluid liquid_redstone_alloy;
    private Fluid liquid_energetic_alloy;
    private Fluid liquid_vibrant_alloy;
    private Fluid liquid_dark_steel;
    private Fluid liquid_electrical_steel;
    private Fluid liquid_phased_iron;
    private Fluid liquid_soularium;

    @Override
    public void onPreInit(Configuration config) {
        this.liquid_redstone_alloy = LiquidMetalRegistry.instance.registerLiquidMetal("RedstoneAlloy", 1000, 14);
        this.liquid_energetic_alloy = LiquidMetalRegistry.instance.registerLiquidMetal("EnergeticAlloy", 2500, 15);
        this.liquid_vibrant_alloy = LiquidMetalRegistry.instance.registerLiquidMetal("VibrantAlloy", 2500, 15);
        this.liquid_dark_steel = LiquidMetalRegistry.instance.registerLiquidMetal("DarkSteel", 1850, 12);
        this.liquid_electrical_steel = LiquidMetalRegistry.instance.registerLiquidMetal("ElectricalSteel", 1850, 15);
        this.liquid_phased_iron = LiquidMetalRegistry.instance.registerLiquidMetal("PulsatingIron", 1850, 15);
        this.liquid_soularium = LiquidMetalRegistry.instance.registerLiquidMetal("Soularium", 1350, 12);
        FoundryUtils.registerBasicMeltingRecipes("RedstoneAlloy", this.liquid_redstone_alloy);
        FoundryUtils.registerBasicMeltingRecipes("EnergeticAlloy", this.liquid_energetic_alloy);
        FoundryUtils.registerBasicMeltingRecipes("VibrantAlloy", this.liquid_vibrant_alloy);
        FoundryUtils.registerBasicMeltingRecipes("PhasedGold", this.liquid_vibrant_alloy);
        FoundryUtils.registerBasicMeltingRecipes("DarkSteel", this.liquid_dark_steel);
        FoundryUtils.registerBasicMeltingRecipes("PulsatingIron", this.liquid_phased_iron);
        FoundryUtils.registerBasicMeltingRecipes("ElectricalSteel", this.liquid_electrical_steel);
        FoundryUtils.registerBasicMeltingRecipes("Soularium", this.liquid_soularium);
    }

    @Override
    public void onInit() {
    }

    private ItemStack getItemStack(String name) {
        return this.getItemStack(name, 0);
    }

    private ItemStack getItemStack(String name, int meta) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("EnderIO", name));
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, meta);
    }

    @Override
    public void onPostInit() {
        if (!Loader.isModLoaded((String)"EnderIO")) {
            return;
        }
        if (FoundryConfig.recipe_equipment) {
            ItemStack extra_sticks1 = new ItemStack(Items.field_151055_y, 1);
            ItemStack extra_sticks2 = new ItemStack(Items.field_151055_y, 2);
            ItemStack dark_steel_pickaxe = this.getItemStack("darkSteel_pickaxe");
            ItemStack dark_steel_axe = this.getItemStack("darkSteel_axe");
            ItemStack dark_steel_shovel = this.getItemStack("darkSteel_shovel");
            ItemStack dark_steel_sword = this.getItemStack("darkSteel_sword");
            ItemStack dark_steel_helmet = this.getItemStack("darkSteel_helmet");
            ItemStack dark_steel_chestplate = this.getItemStack("darkSteel_chestplate");
            ItemStack dark_steel_leggings = this.getItemStack("darkSteel_leggings");
            ItemStack dark_steel_boots = this.getItemStack("darkSteel_boots");
            FoundryMiscUtils.registerCasting(dark_steel_chestplate, this.liquid_dark_steel, 8, ItemMold.SubItem.CHESTPLATE, null);
            FoundryMiscUtils.registerCasting(dark_steel_helmet, this.liquid_dark_steel, 5, ItemMold.SubItem.HELMET, null);
            FoundryMiscUtils.registerCasting(dark_steel_leggings, this.liquid_dark_steel, 7, ItemMold.SubItem.LEGGINGS, null);
            FoundryMiscUtils.registerCasting(dark_steel_boots, this.liquid_dark_steel, 4, ItemMold.SubItem.BOOTS, null);
            FoundryMiscUtils.registerCasting(dark_steel_pickaxe, this.liquid_dark_steel, 3, ItemMold.SubItem.PICKAXE, extra_sticks2);
            FoundryMiscUtils.registerCasting(dark_steel_axe, this.liquid_dark_steel, 3, ItemMold.SubItem.AXE, extra_sticks2);
            FoundryMiscUtils.registerCasting(dark_steel_shovel, this.liquid_dark_steel, 1, ItemMold.SubItem.SHOVEL, extra_sticks2);
            FoundryMiscUtils.registerCasting(dark_steel_sword, this.liquid_dark_steel, 2, ItemMold.SubItem.SWORD, extra_sticks1);
        }
        ItemStack silicon = this.getItemStack("itemMaterial", 0);
        Fluid liquid_redstone = FluidRegistry.getFluid((String)"liquidredstone");
        Fluid liquid_enderpearl = FluidRegistry.getFluid((String)"liquidenderpearl");
        Fluid liquid_glowstone = FluidRegistry.getFluid((String)"liquidglowstone");
        if (silicon != null) {
            InfuserRecipeManager.instance.addRecipe(new FluidStack(this.liquid_redstone_alloy, 108), new FluidStack(liquid_redstone, 100), new ItemStackMatcher(silicon), 50000);
            InfuserRecipeManager.instance.addRecipe(new FluidStack(this.liquid_electrical_steel, 108), new FluidStack(FoundryFluids.liquid_steel, 108), new ItemStackMatcher(silicon), 30000);
        }
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(this.liquid_energetic_alloy, 54), new FluidStack[]{new FluidStack(FoundryFluids.liquid_gold, 54), new FluidStack(liquid_redstone, 50), new FluidStack(liquid_glowstone, 125)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(this.liquid_vibrant_alloy, 54), new FluidStack[]{new FluidStack(this.liquid_energetic_alloy, 54), new FluidStack(liquid_enderpearl, 125)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(this.liquid_phased_iron, 54), new FluidStack[]{new FluidStack(FoundryFluids.liquid_iron, 54), new FluidStack(liquid_enderpearl, 125)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(this.liquid_dark_steel, 27), new FluidStack[]{new FluidStack(FoundryFluids.liquid_steel, 27), new FluidStack(FluidRegistry.LAVA, 250)});
        InfuserRecipeManager.instance.addRecipe(new FluidStack(this.liquid_soularium, 108), new FluidStack(FoundryFluids.liquid_gold, 108), new ItemStackMatcher(new ItemStack(Blocks.field_150425_aM)), 50000);
    }

    @Override
    public String getName() {
        return "EnderIO";
    }

    @Override
    public void onAfterPostInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPostInit() {
    }
}

