/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration;

import exter.foundry.api.FoundryUtils;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.config.FoundryConfig;
import exter.foundry.fluid.FluidLiquidMetal;
import exter.foundry.fluid.LiquidMetalRegistry;
import exter.foundry.integration.IModIntegration;
import exter.foundry.item.FoundryItems;
import exter.foundry.item.ItemMold;
import exter.foundry.recipes.manager.CastingRecipeManager;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import exter.foundry.util.FoundryMiscUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModIntegrationBotania
implements IModIntegration {
    private FluidLiquidMetal liquid_manasteel;
    private FluidLiquidMetal liquid_terrasteel;
    private FluidLiquidMetal liquid_elementium;

    private ItemStack getItemStack(String name) {
        return this.getItemStack(name, 0);
    }

    private ItemStack getItemStack(String name, int meta) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("Botania", name));
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, meta);
    }

    @Override
    public void onPreInit(Configuration config) {
        this.liquid_manasteel = LiquidMetalRegistry.instance.registerLiquidMetal("Manasteel", 1950, 15);
        this.liquid_terrasteel = LiquidMetalRegistry.instance.registerLiquidMetal("Terrasteel", 2100, 15);
        this.liquid_elementium = LiquidMetalRegistry.instance.registerLiquidMetal("ElvenElementium", 2400, 15);
        FoundryUtils.registerBasicMeltingRecipes("Manasteel", this.liquid_manasteel);
        FoundryUtils.registerBasicMeltingRecipes("Terrasteel", this.liquid_terrasteel);
        FoundryUtils.registerBasicMeltingRecipes("ElvenElementium", this.liquid_elementium);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPostInit() {
    }

    @Override
    public void onPostInit() {
        if (!Loader.isModLoaded((String)"Botania")) {
            return;
        }
        ItemStack manasteel_block = this.getItemStack("storage", 0);
        ItemStack terrasteel_block = this.getItemStack("storage", 1);
        ItemStack elementium_block = this.getItemStack("storage", 2);
        ItemStack mold_block = FoundryItems.mold(ItemMold.SubItem.BLOCK);
        MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(manasteel_block), new FluidStack((Fluid)this.liquid_manasteel, 972));
        MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(terrasteel_block), new FluidStack((Fluid)this.liquid_terrasteel, 972));
        MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(elementium_block), new FluidStack((Fluid)this.liquid_elementium, 972));
        CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(manasteel_block), new FluidStack((Fluid)this.liquid_manasteel, 972), mold_block, null);
        CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(terrasteel_block), new FluidStack((Fluid)this.liquid_terrasteel, 972), mold_block, null);
        CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(elementium_block), new FluidStack((Fluid)this.liquid_elementium, 972), mold_block, null);
        if (FoundryConfig.recipe_equipment) {
            ItemStack manasteel_pickaxe = this.getItemStack("manasteelPick");
            ItemStack manasteel_axe = this.getItemStack("manasteelAxe");
            ItemStack manasteel_shovel = this.getItemStack("manasteelShovel");
            ItemStack manasteel_sword = this.getItemStack("manasteelSword");
            ItemStack manasteel_helmet = this.getItemStack("manasteelHelm");
            ItemStack manasteel_chestplate = this.getItemStack("manasteelChest");
            ItemStack manasteel_leggings = this.getItemStack("manasteelLegs");
            ItemStack manasteel_boots = this.getItemStack("manasteelBoots");
            ItemStack terrasteel_sword = this.getItemStack("terraSword");
            ItemStack elementium_pickaxe = this.getItemStack("elementiumPick");
            ItemStack elementium_axe = this.getItemStack("elementiumAxe");
            ItemStack elementium_shovel = this.getItemStack("elementiumShovel");
            ItemStack elementium_sword = this.getItemStack("elementiumSword");
            ItemStack elementium_helmet = this.getItemStack("elementiumHelm");
            ItemStack elementium_chestplate = this.getItemStack("elementiumChest");
            ItemStack elementium_leggings = this.getItemStack("elementiumLegs");
            ItemStack elementium_boots = this.getItemStack("elementiumBoots");
            ItemStack livingwood_twig = this.getItemStack("manaResource", 3);
            ItemStack dreamwood_twig = this.getItemStack("manaResource", 13);
            ItemStack extra_sticks1 = livingwood_twig.func_77946_l();
            ItemStack extra_sticks2 = livingwood_twig.func_77946_l();
            extra_sticks2.field_77994_a = 2;
            ItemStack extra_dreamsticks1 = dreamwood_twig.func_77946_l();
            ItemStack extra_dreamsticks2 = dreamwood_twig.func_77946_l();
            extra_dreamsticks2.field_77994_a = 2;
            FoundryMiscUtils.registerCasting(manasteel_pickaxe, this.liquid_manasteel, 3, ItemMold.SubItem.PICKAXE, extra_sticks2);
            FoundryMiscUtils.registerCasting(manasteel_axe, this.liquid_manasteel, 3, ItemMold.SubItem.AXE, extra_sticks2);
            FoundryMiscUtils.registerCasting(manasteel_shovel, this.liquid_manasteel, 1, ItemMold.SubItem.SHOVEL, extra_sticks2);
            FoundryMiscUtils.registerCasting(manasteel_sword, this.liquid_manasteel, 2, ItemMold.SubItem.SWORD, extra_sticks1);
            FoundryMiscUtils.registerCasting(manasteel_chestplate, this.liquid_manasteel, 8, ItemMold.SubItem.CHESTPLATE, null);
            FoundryMiscUtils.registerCasting(manasteel_leggings, this.liquid_manasteel, 7, ItemMold.SubItem.LEGGINGS, null);
            FoundryMiscUtils.registerCasting(manasteel_helmet, this.liquid_manasteel, 5, ItemMold.SubItem.HELMET, null);
            FoundryMiscUtils.registerCasting(manasteel_boots, this.liquid_manasteel, 4, ItemMold.SubItem.BOOTS, null);
            FoundryMiscUtils.registerCasting(terrasteel_sword, new FluidStack((Fluid)this.liquid_terrasteel, 216), ItemMold.SubItem.SWORD, extra_sticks1);
            FoundryMiscUtils.registerCasting(elementium_pickaxe, this.liquid_elementium, 3, ItemMold.SubItem.PICKAXE, extra_dreamsticks2);
            FoundryMiscUtils.registerCasting(elementium_axe, this.liquid_elementium, 3, ItemMold.SubItem.AXE, extra_dreamsticks2);
            FoundryMiscUtils.registerCasting(elementium_shovel, this.liquid_elementium, 1, ItemMold.SubItem.SHOVEL, extra_dreamsticks2);
            FoundryMiscUtils.registerCasting(elementium_sword, this.liquid_elementium, 2, ItemMold.SubItem.SWORD, extra_dreamsticks1);
            FoundryMiscUtils.registerCasting(elementium_chestplate, this.liquid_elementium, 8, ItemMold.SubItem.CHESTPLATE, null);
            FoundryMiscUtils.registerCasting(elementium_leggings, this.liquid_elementium, 7, ItemMold.SubItem.LEGGINGS, null);
            FoundryMiscUtils.registerCasting(elementium_helmet, this.liquid_elementium, 5, ItemMold.SubItem.HELMET, null);
            FoundryMiscUtils.registerCasting(elementium_boots, this.liquid_elementium, 4, ItemMold.SubItem.BOOTS, null);
        }
    }

    @Override
    public String getName() {
        return "Botania";
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onAfterPostInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientInit() {
    }
}

