/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.init;

import exter.foundry.api.FoundryUtils;
import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.api.recipe.IMeltingRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.api.recipe.matcher.OreMatcher;
import exter.foundry.block.BlockCastingTable;
import exter.foundry.block.BlockComponent;
import exter.foundry.block.BlockFoundryMachine;
import exter.foundry.block.FoundryBlocks;
import exter.foundry.config.FoundryConfig;
import exter.foundry.fluid.FluidLiquidMetal;
import exter.foundry.fluid.FoundryFluids;
import exter.foundry.fluid.LiquidMetalRegistry;
import exter.foundry.init.InitFirearmRecipes;
import exter.foundry.init.InitToolRecipes;
import exter.foundry.item.FoundryItems;
import exter.foundry.item.ItemComponent;
import exter.foundry.item.ItemMold;
import exter.foundry.material.MaterialRegistry;
import exter.foundry.material.OreDictMaterial;
import exter.foundry.material.OreDictType;
import exter.foundry.recipes.manager.AlloyFurnaceRecipeManager;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import exter.foundry.recipes.manager.AtomizerRecipeManager;
import exter.foundry.recipes.manager.BurnerHeaterFuelManager;
import exter.foundry.recipes.manager.CastingRecipeManager;
import exter.foundry.recipes.manager.CastingTableRecipeManager;
import exter.foundry.recipes.manager.InfuserRecipeManager;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import exter.foundry.recipes.manager.MoldRecipeManager;
import exter.foundry.util.FoundryMiscUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class InitRecipes {
    public static void preInit() {
        for (String name : LiquidMetalRegistry.instance.getFluidNames()) {
            FluidLiquidMetal fluid = LiquidMetalRegistry.instance.getFluid(name);
            if (fluid.special) continue;
            FoundryUtils.registerBasicMeltingRecipes(name, fluid);
        }
        FoundryUtils.registerBasicMeltingRecipes("Chromium", LiquidMetalRegistry.instance.getFluid("Chrome"));
        FoundryUtils.registerBasicMeltingRecipes("Aluminum", LiquidMetalRegistry.instance.getFluid("Aluminium"));
        MeltingRecipeManager.instance.addRecipe(new OreMatcher("ingotAlumina"), new FluidStack(FoundryFluids.liquid_aluminium, 108), 2200);
        MeltingRecipeManager.instance.addRecipe(new OreMatcher("nuggetAlumina"), new FluidStack(FoundryFluids.liquid_aluminium, 12), 2200);
        MeltingRecipeManager.instance.addRecipe(new OreMatcher("dustAlumina"), new FluidStack(FoundryFluids.liquid_aluminium, 108), 2200);
        MeltingRecipeManager.instance.addRecipe(new OreMatcher("oreAlumina"), new FluidStack(FoundryFluids.liquid_aluminium, 216), 2200);
        if (FoundryConfig.recipe_glass) {
            String[] oredict_names = new String[]{"dyeSmallBlack", "dyeSmallRed", "dyeSmallGreen", "dyeSmallBrown", "dyeSmallBlue", "dyeSmallPurple", "dyeSmallCyan", "dyeSmallLightGray", "dyeSmallGray", "dyeSmallPink", "dyeSmallLime", "dyeSmallYellow", "dyeSmallLightBlue", "dyeSmallMagenta", "dyeSmallOrange", "dyeSmallWhite"};
            int temp = 1550;
            FluidLiquidMetal liquid_glass = LiquidMetalRegistry.instance.registerSpecialLiquidMetal("Glass", temp, 12, new ItemStack(Blocks.field_150359_w));
            MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher((Block)Blocks.field_150354_m), new FluidStack((Fluid)liquid_glass, 1000), temp, 250);
            MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(Blocks.field_150359_w), new FluidStack((Fluid)liquid_glass, 1000), temp, 250);
            MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(Blocks.field_150410_aZ), new FluidStack((Fluid)liquid_glass, 375), temp, 250);
            CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(Blocks.field_150359_w), new FluidStack((Fluid)liquid_glass, 1000), FoundryItems.mold(ItemMold.SubItem.BLOCK), null, 400);
            CastingTableRecipeManager.instance.addRecipe(new ItemStackMatcher(Blocks.field_150359_w), new FluidStack((Fluid)liquid_glass, 1000), ICastingTableRecipe.TableType.BLOCK);
            for (EnumDyeColor dye : EnumDyeColor.values()) {
                String name = dye.func_176610_l();
                int color = ItemDye.field_150922_c[dye.func_176767_b()];
                int c1 = 63 + (color & 0xFF) * 3 / 4;
                int c2 = 63 + (color >> 8 & 0xFF) * 3 / 4;
                int c3 = 63 + (color >> 16 & 0xFF) * 3 / 4;
                int fluid_color = c1 | c2 << 8 | c3 << 16;
                int meta = dye.func_176765_a();
                ItemStack stained_glass = new ItemStack((Block)Blocks.field_150399_cn, 1, meta);
                FluidLiquidMetal liquid_glass_colored = LiquidMetalRegistry.instance.registerSpecialLiquidMetal("Glass." + name, temp, 12, "liquidGlass", fluid_color, stained_glass);
                MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(stained_glass), new FluidStack((Fluid)liquid_glass_colored, 1000), temp, 250);
                MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(new ItemStack((Block)Blocks.field_150397_co, 1, meta)), new FluidStack((Fluid)liquid_glass_colored, 375), temp, 250);
                CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(stained_glass), new FluidStack((Fluid)liquid_glass_colored, 1000), FoundryItems.mold(ItemMold.SubItem.BLOCK), null, 400);
                CastingTableRecipeManager.instance.addRecipe(new ItemStackMatcher(stained_glass), new FluidStack((Fluid)liquid_glass_colored, 1000), ICastingTableRecipe.TableType.BLOCK);
                InfuserRecipeManager.instance.addRecipe(new FluidStack((Fluid)liquid_glass_colored, 2000), new FluidStack((Fluid)liquid_glass, 2000), new OreMatcher(oredict_names[dye.func_176767_b()]), 5000);
            }
        }
    }

    public static void init() {
        Fluid liquid_redstone = FluidRegistry.getFluid((String)"liquidredstone");
        Fluid liquid_glowstone = FluidRegistry.getFluid((String)"liquidglowstone");
        Fluid liquid_enderpearl = FluidRegistry.getFluid((String)"liquidenderpearl");
        MeltingRecipeManager.instance.addRecipe(new OreMatcher("dustRedstone"), new FluidStack(liquid_redstone, 100));
        MeltingRecipeManager.instance.addRecipe(new OreMatcher("dustGlowstone"), new FluidStack(liquid_glowstone, 250), liquid_glowstone.getTemperature(), 90);
        MeltingRecipeManager.instance.addRecipe(new OreMatcher("dustEnderpearl"), new FluidStack(liquid_enderpearl, 250), liquid_enderpearl.getTemperature(), 75);
        MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(Items.field_151079_bi), new FluidStack(liquid_enderpearl, 250), liquid_enderpearl.getTemperature(), 75);
        MeltingRecipeManager.instance.addRecipe(new OreMatcher("blockRedstone"), new FluidStack(liquid_redstone, 900));
        MeltingRecipeManager.instance.addRecipe(new OreMatcher("blockGlowstone"), new FluidStack(liquid_glowstone, 1000), liquid_glowstone.getTemperature(), 90);
        MoldRecipeManager.instance.addRecipe(FoundryItems.mold(ItemMold.SubItem.INGOT), 2, 4, new int[]{2, 2, 2, 2, 2, 2, 2, 2});
        MoldRecipeManager.instance.addRecipe(FoundryItems.mold(ItemMold.SubItem.PLATE), 4, 4, new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
        MoldRecipeManager.instance.addRecipe(FoundryItems.mold(ItemMold.SubItem.ROD), 1, 6, new int[]{1, 1, 1, 1, 1, 1});
        MoldRecipeManager.instance.addRecipe(FoundryItems.mold(ItemMold.SubItem.GEAR), 5, 5, new int[]{1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1});
        MoldRecipeManager.instance.addRecipe(FoundryItems.mold(ItemMold.SubItem.BLOCK), 6, 6, new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4});
        MoldRecipeManager.instance.addRecipe(FoundryItems.mold(ItemMold.SubItem.SLAB), 6, 6, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4});
        MoldRecipeManager.instance.addRecipe(FoundryItems.mold(ItemMold.SubItem.STAIRS), 6, 6, new int[]{0, 0, 0, 4, 4, 4, 0, 0, 0, 4, 4, 4, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4});
        AlloyFurnaceRecipeManager.instance.addRecipe(new ItemStack((Block)FoundryBlocks.block_refractory_glass), new ItemStackMatcher((Block)Blocks.field_150354_m), new ItemStackMatcher(Items.field_151119_aD));
        AlloyFurnaceRecipeManager.instance.addRecipe(FoundryMiscUtils.getModItemFromOreDictionary("substratum", "ingotBronze", 4), new IItemMatcher[]{new OreMatcher("ingotCopper", 3), new OreMatcher("dustCopper", 3)}, new IItemMatcher[]{new OreMatcher("ingotTin", 1), new OreMatcher("dustTin", 1)});
        AlloyFurnaceRecipeManager.instance.addRecipe(FoundryMiscUtils.getModItemFromOreDictionary("substratum", "ingotBrass", 4), new IItemMatcher[]{new OreMatcher("ingotCopper", 3), new OreMatcher("dustCopper", 3)}, new IItemMatcher[]{new OreMatcher("ingotZinc", 1), new OreMatcher("dustZinc", 1)});
        AlloyFurnaceRecipeManager.instance.addRecipe(FoundryMiscUtils.getModItemFromOreDictionary("substratum", "ingotInvar", 3), new IItemMatcher[]{new OreMatcher("ingotIron", 2), new OreMatcher("dustIron", 2)}, new IItemMatcher[]{new OreMatcher("ingotNickel", 1), new OreMatcher("dustNickel", 1)});
        AlloyFurnaceRecipeManager.instance.addRecipe(FoundryMiscUtils.getModItemFromOreDictionary("substratum", "ingotElectrum", 2), new IItemMatcher[]{new OreMatcher("ingotGold", 1), new OreMatcher("dustGold", 1)}, new IItemMatcher[]{new OreMatcher("ingotSilver", 1), new OreMatcher("dustSilver", 1)});
        AlloyFurnaceRecipeManager.instance.addRecipe(FoundryMiscUtils.getModItemFromOreDictionary("substratum", "ingotCupronickel", 2), new IItemMatcher[]{new OreMatcher("ingotCopper", 1), new OreMatcher("dustCopper", 1)}, new IItemMatcher[]{new OreMatcher("ingotNickel", 1), new OreMatcher("dustNickel", 1)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_bronze, 4), new FluidStack[]{new FluidStack(FoundryFluids.liquid_copper, 3), new FluidStack(FoundryFluids.liquid_tin, 1)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_brass, 4), new FluidStack[]{new FluidStack(FoundryFluids.liquid_copper, 3), new FluidStack(FoundryFluids.liquid_zinc, 1)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_invar, 3), new FluidStack[]{new FluidStack(FoundryFluids.liquid_iron, 2), new FluidStack(FoundryFluids.liquid_nickel, 1)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_electrum, 2), new FluidStack[]{new FluidStack(FoundryFluids.liquid_gold, 1), new FluidStack(FoundryFluids.liquid_silver, 1)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_cupronickel, 2), new FluidStack[]{new FluidStack(FoundryFluids.liquid_copper, 1), new FluidStack(FoundryFluids.liquid_nickel, 1)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_signalum, 108), new FluidStack[]{new FluidStack(FoundryFluids.liquid_copper, 81), new FluidStack(FoundryFluids.liquid_silver, 27), new FluidStack(liquid_redstone, 250)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_lumium, 108), new FluidStack[]{new FluidStack(FoundryFluids.liquid_tin, 81), new FluidStack(FoundryFluids.liquid_silver, 27), new FluidStack(liquid_glowstone, 250)});
        AlloyMixerRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_enderium, 108), new FluidStack[]{new FluidStack(FoundryFluids.liquid_tin, 54), new FluidStack(FoundryFluids.liquid_silver, 27), new FluidStack(FoundryFluids.liquid_platinum, 27), new FluidStack(liquid_enderpearl, 250)});
        ItemStack mold_ingot = FoundryItems.mold(ItemMold.SubItem.INGOT);
        ItemStack mold_slab = FoundryItems.mold(ItemMold.SubItem.SLAB);
        ItemStack mold_stairs = FoundryItems.mold(ItemMold.SubItem.STAIRS);
        ItemStack mold_plate = FoundryItems.mold(ItemMold.SubItem.PLATE);
        ItemStack mold_block = FoundryItems.mold(ItemMold.SubItem.BLOCK);
        ItemStack mold_gear = FoundryItems.mold(ItemMold.SubItem.GEAR);
        ItemStack mold_rod = FoundryItems.mold(ItemMold.SubItem.ROD);
        for (ItemMold.SubItem sub : ItemMold.SubItem.values()) {
            CastingRecipeManager.instance.addMold(FoundryItems.mold(sub));
        }
        if (FoundryConfig.recipe_equipment) {
            InitToolRecipes.init();
        }
        for (String name : LiquidMetalRegistry.instance.getFluidNames()) {
            ItemStack rod;
            ItemStack plate;
            ItemStack gear;
            ItemStack dust;
            ItemStack stairs;
            ItemStack slab;
            ItemStack block;
            FluidLiquidMetal fluid = LiquidMetalRegistry.instance.getFluid(name);
            if (fluid.special) continue;
            ItemStack ingot = FoundryMiscUtils.getModItemFromOreDictionary("substratum", "ingot" + name);
            if (ingot != null) {
                FluidStack fluid_stack = new FluidStack((Fluid)fluid, 108);
                CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(ingot), fluid_stack, mold_ingot, null);
                CastingTableRecipeManager.instance.addRecipe(new ItemStackMatcher(ingot), fluid_stack, ICastingTableRecipe.TableType.INGOT);
            }
            if ((block = FoundryMiscUtils.getModItemFromOreDictionary("substratum", "block" + name)) != null) {
                FluidStack fluid_stack = new FluidStack((Fluid)fluid, 972);
                CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(block), fluid_stack, mold_block, null);
                CastingTableRecipeManager.instance.addRecipe(new ItemStackMatcher(block), fluid_stack, ICastingTableRecipe.TableType.BLOCK);
            }
            if ((slab = FoundryMiscUtils.getModItemFromOreDictionary("substratum", "slab" + name)) != null) {
                FluidStack fluid_stack = new FluidStack((Fluid)fluid, 486);
                CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(slab), fluid_stack, mold_slab, null);
                MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(slab), fluid_stack);
            }
            if ((stairs = FoundryMiscUtils.getModItemFromOreDictionary("substratum", "stairs" + name)) != null) {
                FluidStack fluid_stack = new FluidStack((Fluid)fluid, 729);
                CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(stairs), fluid_stack, mold_stairs, null);
                MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(stairs), fluid_stack);
            }
            if ((dust = FoundryMiscUtils.getModItemFromOreDictionary("substratum", "dust" + name)) != null) {
                AtomizerRecipeManager.instance.addRecipe(new ItemStackMatcher(dust), new FluidStack((Fluid)fluid, 108));
            }
            if ((gear = FoundryMiscUtils.getModItemFromOreDictionary("substratum", "gear" + name)) != null) {
                FluidStack fluid_stack = new FluidStack((Fluid)fluid, 432);
                CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(gear), fluid_stack, mold_gear, null);
                MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(gear), fluid_stack);
            }
            if ((plate = FoundryMiscUtils.getModItemFromOreDictionary("substratum", "plate" + name)) != null) {
                FluidStack fluid_stack = new FluidStack((Fluid)fluid, 108);
                CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(plate), fluid_stack, mold_plate, null);
                CastingTableRecipeManager.instance.addRecipe(new ItemStackMatcher(plate), fluid_stack, ICastingTableRecipe.TableType.PLATE);
                MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(plate), fluid_stack);
            }
            if ((rod = FoundryMiscUtils.getModItemFromOreDictionary("substratum", "rod" + name)) == null) continue;
            FluidStack fluid_stack = new FluidStack((Fluid)fluid, 54);
            CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(rod), fluid_stack, mold_rod, null);
            CastingTableRecipeManager.instance.addRecipe(new ItemStackMatcher(rod), fluid_stack, ICastingTableRecipe.TableType.ROD);
            MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(rod), fluid_stack);
        }
        if (FoundryConfig.recipe_steel) {
            InfuserRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_steel, 36), new FluidStack(FoundryFluids.liquid_iron, 36), new OreMatcher("dustCoal"), 160000);
            InfuserRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_steel, 12), new FluidStack(FoundryFluids.liquid_iron, 12), new OreMatcher("dustCharcoal"), 160000);
            InfuserRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_steel, 9), new FluidStack(FoundryFluids.liquid_iron, 9), new OreMatcher("dustSmallCoal"), 20000);
            InfuserRecipeManager.instance.addRecipe(new FluidStack(FoundryFluids.liquid_steel, 3), new FluidStack(FoundryFluids.liquid_iron, 3), new OreMatcher("dustSmallCharcoal"), 20000);
        }
        BurnerHeaterFuelManager.instance.addFuel(new ItemStackMatcher(new ItemStack(Items.field_151044_h, 1, 0)), 1600, BurnerHeaterFuelManager.instance.getHeatNeeded(187000, 750));
        BurnerHeaterFuelManager.instance.addFuel(new ItemStackMatcher(new ItemStack(Items.field_151044_h, 1, 1)), 1200, BurnerHeaterFuelManager.instance.getHeatNeeded(187000, 750));
        BurnerHeaterFuelManager.instance.addFuel(new OreMatcher("itemCoalCoke"), 3200, BurnerHeaterFuelManager.instance.getHeatNeeded(215000, 750));
        BurnerHeaterFuelManager.instance.addFuel(new OreMatcher("dustCoal"), 800, BurnerHeaterFuelManager.instance.getHeatNeeded(195000, 750));
        BurnerHeaterFuelManager.instance.addFuel(new OreMatcher("dustCharcoal"), 800, BurnerHeaterFuelManager.instance.getHeatNeeded(192000, 750));
        BurnerHeaterFuelManager.instance.addFuel(new OreMatcher("dustSmallCoal"), 200, BurnerHeaterFuelManager.instance.getHeatNeeded(195000, 750));
        BurnerHeaterFuelManager.instance.addFuel(new OreMatcher("dustSmallCharcoal"), 200, BurnerHeaterFuelManager.instance.getHeatNeeded(192000, 750));
        BurnerHeaterFuelManager.instance.addFuel(new ItemStackMatcher(Items.field_151072_bj), 2000, BurnerHeaterFuelManager.instance.getHeatNeeded(220000, 750));
        ItemStack redstone_stack = new ItemStack(Items.field_151137_ax);
        ItemStack furnace_stack = new ItemStack(Blocks.field_150460_al);
        ItemStack clay_stack = new ItemStack(Items.field_151119_aD);
        ItemStack sand_stack = new ItemStack((Block)Blocks.field_150354_m, 1, -1);
        ItemStack soulsand_stack = new ItemStack(Blocks.field_150425_aM);
        ItemStack clayblock_stack = new ItemStack(Blocks.field_150435_aG, 1, -1);
        ItemStack casing_stack = FoundryBlocks.block_component.asItemStack(BlockComponent.EnumVariant.REFCASING);
        ItemStack casing_inferno_stack = FoundryBlocks.block_component.asItemStack(BlockComponent.EnumVariant.INFCASING);
        ItemStack piston_stack = new ItemStack((Block)Blocks.field_150331_J);
        ItemStack goldnugget_stack = new ItemStack(Items.field_151074_bl);
        ItemStack cauldron_stack = new ItemStack(Items.field_151066_bu);
        ItemStack chest_stack = new ItemStack((Block)Blocks.field_150486_ae);
        ItemStack refclay_stack = FoundryItems.component(ItemComponent.SubItem.REFRACTORYCLAY);
        ItemStack refclay_small_stack = FoundryItems.component(ItemComponent.SubItem.REFRACTORYCLAY_SMALL);
        ItemStack refractoryclay8_stack = FoundryItems.component(ItemComponent.SubItem.REFRACTORYCLAY, 8);
        ItemStack refbrick_stack = FoundryItems.component(ItemComponent.SubItem.REFRACTORYBRICK);
        ItemStack refglass_stack = new ItemStack((Block)FoundryBlocks.block_refractory_glass);
        ItemStack heatingcoil_stack = FoundryItems.component(ItemComponent.SubItem.HEATINGCOIL);
        ItemStack emptycontainer2_stack = FoundryItems.item_container.empty(2);
        ItemStack comparator_stack = new ItemStack(Items.field_151132_bS);
        ItemStack repeater_stack = new ItemStack(Items.field_151107_aW);
        ItemStack bucket_stack = new ItemStack(Items.field_151133_ar);
        ItemStack magmacream_stack = new ItemStack(Items.field_151064_bs);
        ItemStack infernoclay8_stack = FoundryItems.component(ItemComponent.SubItem.INFERNOCLAY, 8);
        ItemStack infbrick_stack = FoundryItems.component(ItemComponent.SubItem.INFERNOBRICK);
        GameRegistry.addRecipe((ItemStack)refractoryclay8_stack, (Object[])new Object[]{"CCC", "CSC", "CCC", Character.valueOf('C'), clay_stack, Character.valueOf('S'), sand_stack});
        GameRegistry.addRecipe((ItemStack)FoundryBlocks.block_component.asItemStack(BlockComponent.EnumVariant.REFCLAYBLOCK), (Object[])new Object[]{"CC", "CC", Character.valueOf('C'), refclay_stack});
        GameRegistry.addRecipe((ItemStack)refclay_stack, (Object[])new Object[]{"CC", "CC", Character.valueOf('C'), refclay_small_stack});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(infernoclay8_stack, new Object[]{"COC", "CSC", "CMC", Character.valueOf('C'), refclay_stack, Character.valueOf('S'), soulsand_stack, Character.valueOf('M'), magmacream_stack, Character.valueOf('O'), "dustObsidian"}));
        GameRegistry.addShapelessRecipe((ItemStack)refractoryclay8_stack, (Object[])new Object[]{clayblock_stack, clayblock_stack, sand_stack});
        GameRegistry.addSmelting((ItemStack)FoundryItems.component(ItemComponent.SubItem.REFRACTORYCLAY), (ItemStack)refbrick_stack, (float)0.0f);
        GameRegistry.addSmelting((ItemStack)FoundryItems.component(ItemComponent.SubItem.INFERNOCLAY), (ItemStack)infbrick_stack, (float)0.0f);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(emptycontainer2_stack, new Object[]{" T ", "BGB", " T ", Character.valueOf('T'), "plateTin", Character.valueOf('B'), refbrick_stack, Character.valueOf('G'), refglass_stack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FoundryItems.component(ItemComponent.SubItem.HEATINGCOIL, 2), new Object[]{"CCC", "CRC", "CCC", Character.valueOf('C'), "rodCupronickel", Character.valueOf('G'), goldnugget_stack, Character.valueOf('R'), redstone_stack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(casing_stack, new Object[]{"IBI", "B B", "IBI", Character.valueOf('I'), "plateIron", Character.valueOf('B'), refbrick_stack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(casing_inferno_stack, new Object[]{"IBI", "B B", "IBI", Character.valueOf('I'), "plateSteel", Character.valueOf('B'), infbrick_stack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FoundryBlocks.block_refractory_tank), new Object[]{"BPB", "G G", "BPB", Character.valueOf('G'), refglass_stack, Character.valueOf('P'), "plateIron", Character.valueOf('B'), refbrick_stack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FoundryBlocks.block_inferno_tank), new Object[]{"BPB", "G G", "BPB", Character.valueOf('G'), refglass_stack, Character.valueOf('P'), "plateSteel", Character.valueOf('B'), infbrick_stack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FoundryBlocks.block_burner_heater), new Object[]{"I", "C", "F", Character.valueOf('F'), furnace_stack, Character.valueOf('I'), "plateCopper", Character.valueOf('C'), casing_stack}));
        GameRegistry.addRecipe((ItemStack)FoundryBlocks.block_casting_table.asItemStack(BlockCastingTable.EnumTable.INGOT), (Object[])new Object[]{"BMB", " S ", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('B'), refbrick_stack, Character.valueOf('M'), mold_ingot});
        GameRegistry.addRecipe((ItemStack)FoundryBlocks.block_casting_table.asItemStack(BlockCastingTable.EnumTable.PLATE), (Object[])new Object[]{"BMB", " S ", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('B'), refbrick_stack, Character.valueOf('M'), mold_plate});
        GameRegistry.addRecipe((ItemStack)FoundryBlocks.block_casting_table.asItemStack(BlockCastingTable.EnumTable.ROD), (Object[])new Object[]{"BMB", " S ", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('B'), refbrick_stack, Character.valueOf('M'), mold_rod});
        GameRegistry.addRecipe((ItemStack)FoundryBlocks.block_casting_table.asItemStack(BlockCastingTable.EnumTable.BLOCK), (Object[])new Object[]{"BMB", " S ", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('B'), refbrick_stack, Character.valueOf('M'), mold_block});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)FoundryBlocks.block_refractory_spout, new Object[]{"RL", "BB", "R ", Character.valueOf('R'), "rodIron", Character.valueOf('B'), refbrick_stack, Character.valueOf('L'), new ItemStack(Blocks.field_150442_at)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.INDUCTIONHEATER), new Object[]{"HIH", "RCR", "HRH", Character.valueOf('H'), heatingcoil_stack, Character.valueOf('R'), redstone_stack, Character.valueOf('I'), "plateCopper", Character.valueOf('C'), casing_stack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.CRUCIBLE), new Object[]{"BAB", "BCB", "BIB", Character.valueOf('B'), refbrick_stack, Character.valueOf('I'), "plateCopper", Character.valueOf('C'), casing_stack, Character.valueOf('A'), cauldron_stack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.ADVCRUCIBLE), new Object[]{"BAB", "BCB", "BIB", Character.valueOf('B'), infbrick_stack, Character.valueOf('I'), "plateSilver", Character.valueOf('C'), casing_inferno_stack, Character.valueOf('A'), cauldron_stack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.INFUSER), new Object[]{" R ", "GCG", "HRH", Character.valueOf('R'), redstone_stack, Character.valueOf('B'), refbrick_stack, Character.valueOf('C'), casing_stack, Character.valueOf('G'), "gearInvar", Character.valueOf('H'), heatingcoil_stack}));
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)FoundryBlocks.block_alloy_furnace), (Object[])new Object[]{"BBB", "BFB", "BBB", Character.valueOf('B'), refbrick_stack, Character.valueOf('F'), furnace_stack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)FoundryBlocks.block_refractory_hopper), (Object[])new Object[]{"R R", "RBR", " R ", Character.valueOf('R'), refbrick_stack, Character.valueOf('B'), bucket_stack});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.ATOMIZER), new Object[]{"GHG", "RCR", " B ", Character.valueOf('H'), new ItemStack((Block)FoundryBlocks.block_refractory_hopper), Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), casing_stack, Character.valueOf('G'), "gearBronze"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.CASTER), new Object[]{" H ", "RCR", "GPG", Character.valueOf('H'), chest_stack, Character.valueOf('G'), "gearIron", Character.valueOf('P'), piston_stack, Character.valueOf('C'), casing_stack, Character.valueOf('R'), redstone_stack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.ALLOYMIXER), new Object[]{" P ", "GCG", " R ", Character.valueOf('C'), casing_stack, Character.valueOf('R'), redstone_stack, Character.valueOf('G'), "gearInvar", Character.valueOf('P'), "plateInvar"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FoundryBlocks.block_machine.asItemStack(BlockFoundryMachine.EnumMachine.MATERIALROUTER), new Object[]{"GEG", "PRP", "GCG", Character.valueOf('R'), casing_stack, Character.valueOf('P'), "plateSignalum", Character.valueOf('C'), comparator_stack, Character.valueOf('E'), repeater_stack, Character.valueOf('G'), "gearBrass"}));
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)FoundryBlocks.block_mold_station), (Object[])new Object[]{"BWB", "BSB", "BFB", Character.valueOf('B'), refbrick_stack, Character.valueOf('W'), new ItemStack(Blocks.field_150462_ai), Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('F'), furnace_stack});
        if (FoundryConfig.block_cokeoven) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FoundryBlocks.block_coke_oven), new Object[]{"BFB", "BCB", "BIB", Character.valueOf('B'), refbrick_stack, Character.valueOf('F'), furnace_stack, Character.valueOf('I'), "plateCopper", Character.valueOf('C'), casing_stack}));
        }
        InitFirearmRecipes.init();
    }

    public static void postInit() {
        for (OreDictType type : OreDictType.TYPES) {
            for (OreDictMaterial material : OreDictMaterial.MATERIALS) {
                String od_name = type.prefix + material.suffix;
                for (ItemStack item : OreDictionary.getOres((String)od_name)) {
                    MaterialRegistry.instance.registerItem(item, material.suffix, type.name);
                }
                if (material.suffix_alias == null) continue;
                od_name = type.prefix + material.suffix_alias;
                for (ItemStack item : OreDictionary.getOres((String)od_name)) {
                    MaterialRegistry.instance.registerItem(item, material.suffix, type.name);
                }
            }
        }
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            int[] ids;
            ItemStack result;
            IMeltingRecipe recipe;
            ItemStack stack = (ItemStack)entry.getKey();
            if (stack == null || stack.func_77973_b() == null || MeltingRecipeManager.instance.findRecipe(stack) != null || (recipe = MeltingRecipeManager.instance.findRecipe(result = (ItemStack)entry.getValue())) == null) continue;
            Fluid liquid_metal = recipe.getOutput().getFluid();
            int base_amount = recipe.getOutput().amount;
            for (int j : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)j).startsWith("ore")) continue;
                base_amount = 216;
                break;
            }
            MeltingRecipeManager.instance.addRecipe(new ItemStackMatcher(stack), new FluidStack(liquid_metal, base_amount * result.field_77994_a), recipe.getMeltingPoint(), recipe.getMeltingSpeed());
        }
        ItemStack ingot_mold = FoundryItems.mold(ItemMold.SubItem.INGOT);
        ItemStack itemStack = FoundryItems.mold(ItemMold.SubItem.BLOCK);
        for (String name : LiquidMetalRegistry.instance.getFluidNames()) {
            FluidLiquidMetal fluid = LiquidMetalRegistry.instance.getFluid(name);
            if (fluid.special) continue;
            FluidStack fluidstack = new FluidStack((Fluid)fluid, 108);
            List ores = OreDictionary.getOres((String)("ingot" + name));
            if (ores != null && ores.size() > 0) {
                if (CastingRecipeManager.instance.findRecipe(fluidstack, ingot_mold, null) == null) {
                    CastingRecipeManager.instance.addRecipe(new OreMatcher("ingot" + name), fluidstack, ingot_mold, null);
                }
                if (CastingTableRecipeManager.instance.findRecipe(fluidstack, ICastingTableRecipe.TableType.INGOT) == null) {
                    CastingTableRecipeManager.instance.addRecipe(new OreMatcher("ingot" + name), fluidstack, ICastingTableRecipe.TableType.INGOT);
                }
            }
            if ((ores = OreDictionary.getOres((String)("dust" + name))) != null && ores.size() > 0 && AtomizerRecipeManager.instance.findRecipe(fluidstack) == null) {
                AtomizerRecipeManager.instance.addRecipe(new OreMatcher("dust" + name), fluidstack);
            }
            ores = OreDictionary.getOres((String)("block" + name));
            fluidstack = new FluidStack((Fluid)LiquidMetalRegistry.instance.getFluid(name), 972);
            if (ores == null || ores.size() <= 0) continue;
            if (CastingRecipeManager.instance.findRecipe(fluidstack, itemStack, null) == null) {
                CastingRecipeManager.instance.addRecipe(new OreMatcher("block" + name), fluidstack, itemStack, null);
            }
            if (CastingTableRecipeManager.instance.findRecipe(fluidstack, ICastingTableRecipe.TableType.BLOCK) != null) continue;
            CastingTableRecipeManager.instance.addRecipe(new OreMatcher("block" + name), fluidstack, ICastingTableRecipe.TableType.BLOCK);
        }
    }
}

