/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.gui;

import exter.foundry.container.ContainerMaterialRouter;
import exter.foundry.gui.GuiFoundry;
import exter.foundry.gui.button.GuiButtonFoundry;
import exter.foundry.material.MaterialRegistry;
import exter.foundry.tileentity.TileEntityMaterialRouter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMaterialRouter
extends GuiFoundry {
    private TileEntityMaterialRouter te_router;
    private List<FilterSlot> material_slots;
    private List<FilterSlot> type_slots;
    private GuiButtonFoundry[] route_buttons;
    private GuiButtonFoundry material_scroll_left;
    private GuiButtonFoundry material_scroll_right;
    private GuiButtonFoundry type_scroll_left;
    private GuiButtonFoundry type_scroll_right;
    private GuiButtonFoundry route_scroll_up;
    private GuiButtonFoundry route_scroll_down;
    private boolean do_scroll_sync;
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("foundry:textures/gui/materialrouter.png");

    private void drawMaterialIcon(int x, int y, String name) {
        if (name.equals("_Any")) {
            GL11.glEnable((int)3042);
            this.func_73729_b(x, y, 216, 193, 16, 16);
        } else {
            this.drawItemStack(x, y, MaterialRegistry.instance.getMaterialIcon(name));
        }
    }

    private void drawTypeIcon(int x, int y, String name) {
        if (name.equals("_Any")) {
            GL11.glEnable((int)3042);
            this.func_73729_b(x, y, 216, 193, 16, 16);
        } else {
            this.drawItemStack(x, y, MaterialRegistry.instance.getTypeIcon(name));
        }
    }

    public GuiMaterialRouter(TileEntityMaterialRouter router, EntityPlayer player) {
        super(new ContainerMaterialRouter(router, player));
        this.field_146291_p = false;
        this.field_146999_f = 200;
        this.field_147000_g = 229;
        this.te_router = router;
        this.material_slots = new ArrayList<FilterSlot>();
        this.material_slots.add(new FilterSlotMaterial(0, "_Any"));
        ArrayList<String> materials = new ArrayList<String>(MaterialRegistry.instance.getMaterialNames());
        Collections.sort(materials, String.CASE_INSENSITIVE_ORDER);
        int i = 1;
        for (String name : materials) {
            this.material_slots.add(new FilterSlotMaterial(i++, name));
        }
        this.type_slots = new ArrayList<FilterSlot>();
        this.type_slots.add(new FilterSlotType(0, "_Any"));
        ArrayList<String> types = new ArrayList<String>(MaterialRegistry.instance.getTypeNames());
        Collections.sort(types, String.CASE_INSENSITIVE_ORDER);
        i = 1;
        for (String name : types) {
            this.type_slots.add(new FilterSlotType(i++, name));
        }
        this.do_scroll_sync = false;
    }

    @Override
    protected ResourceLocation getGUITexture() {
        return GUI_TEXTURE;
    }

    public void func_73863_a(int mousex, int mousey, float par3) {
        int index;
        FilterSlot slot;
        int index2;
        int i;
        super.func_73863_a(mousex, mousey, par3);
        for (i = 0; i < 8 && (index2 = i + this.te_router.gui_material_scroll) < this.material_slots.size(); ++i) {
            slot = this.material_slots.get(index2);
            if (!this.func_146978_c(111 + 17 * (i % 4), 24 + 17 * (i / 4), 16, 16, mousex, mousey)) continue;
            slot.drawTooltip(mousex, mousey);
        }
        for (i = 0; i < 8 && (index2 = i + this.te_router.gui_type_scroll) < this.type_slots.size(); ++i) {
            slot = this.type_slots.get(index2);
            if (!this.func_146978_c(111 + 17 * (i % 4), 70 + 17 * (i / 4), 16, 16, mousex, mousey)) continue;
            slot.drawTooltip(mousex, mousey);
        }
        List<TileEntityMaterialRouter.Route> routes = this.te_router.getRoutes();
        for (i = 0; i < 4 && (index = i + this.te_router.gui_route_scroll) < routes.size(); ++i) {
            ArrayList<String> tooltip;
            TileEntityMaterialRouter.Route r = routes.get(index);
            int y = 49 + i * 17;
            if (this.func_146978_c(29, y, 16, 16, mousex, mousey)) {
                tooltip = new ArrayList<String>();
                tooltip.add(new TextComponentTranslation("foundry.router.material." + r.material, new Object[0]).func_150260_c());
                this.drawHoveringText(tooltip, mousex, mousey, this.field_146289_q);
            }
            if (this.func_146978_c(46, y, 16, 16, mousex, mousey)) {
                tooltip = new ArrayList();
                tooltip.add(new TextComponentTranslation("foundry.router.type." + r.type, new Object[0]).func_150260_c());
                this.drawHoveringText(tooltip, mousex, mousey, this.field_146289_q);
            }
            if (!this.func_146978_c(81, y + 4, 8, 8, mousex, mousey)) continue;
            tooltip = new ArrayList();
            tooltip.add("Remove");
            this.drawHoveringText(tooltip, mousex, mousey, this.field_146289_q);
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        int index;
        int index2;
        FilterSlot slot;
        int index3;
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GUI_TEXTURE);
        int window_x = (this.field_146294_l - this.field_146999_f) / 2;
        int window_y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(window_x, window_y, 0, 0, this.field_146999_f, this.field_147000_g);
        for (i = 0; i < 8 && (index3 = i + this.te_router.gui_material_scroll) < this.material_slots.size(); ++i) {
            slot = this.material_slots.get(index3);
            slot.draw(window_x + 111 + 17 * (i % 4), window_y + 24 + 17 * (i / 4));
        }
        for (i = 0; i < 8 && (index3 = i + this.te_router.gui_type_scroll) < this.type_slots.size(); ++i) {
            slot = this.type_slots.get(index3);
            slot.draw(window_x + 111 + 17 * (i % 4), window_y + 70 + 17 * (i / 4));
        }
        int selected_material = this.te_router.gui_material_selected;
        int selected_type = this.te_router.gui_type_selected;
        int material_scroll = this.te_router.gui_material_scroll;
        int type_scroll = this.te_router.gui_type_scroll;
        GL11.glEnable((int)3042);
        if (selected_material >= material_scroll && selected_material < material_scroll + 8) {
            index2 = selected_material - material_scroll;
            this.func_73729_b(window_x + 111 + 17 * (index2 % 4), window_y + 24 + 17 * (index2 / 4), 200, 193, 16, 16);
        }
        if (selected_type >= type_scroll && selected_type < type_scroll + 8) {
            index2 = selected_type - type_scroll;
            this.func_73729_b(window_x + 111 + 17 * (index2 % 4), window_y + 70 + 17 * (index2 / 4), 200, 193, 16, 16);
        }
        List<TileEntityMaterialRouter.Route> routes = this.te_router.getRoutes();
        for (i = 0; i < 4 && (index = i + this.te_router.gui_route_scroll) < routes.size(); ++i) {
            TileEntityMaterialRouter.Route r = routes.get(index);
            int y = 49 + i * 17;
            this.drawMaterialIcon(window_x + 29, window_y + y, r.material);
            this.drawTypeIcon(window_x + 46, window_y + y, r.type);
            GL11.glEnable((int)3042);
            this.func_73729_b(window_x + 63, window_y + y, 200, r.side.func_176745_a() * 16, 16, 16);
            this.func_73729_b(window_x + 81, window_y + y + 4, 234, 194, 8, 8);
        }
    }

    protected void func_146979_b(int mouse_x, int mouse_y) {
        super.func_146979_b(mouse_x, mouse_y);
        this.field_146289_q.func_78276_b("Material Router", 6, 6, 0x404040);
        this.field_146289_q.func_78276_b("Inventory", 32, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b("Materials(" + (this.te_router.gui_material_scroll / 8 + 1) + "/" + (int)Math.ceil((double)this.material_slots.size() / 8.0) + "):", 111, 14, 0x404040);
        this.field_146289_q.func_78276_b("Types(" + (this.te_router.gui_type_scroll / 8 + 1) + "/" + (int)Math.ceil((double)this.type_slots.size() / 8.0) + "):", 111, 60, 0x404040);
    }

    protected void func_73864_a(int x, int y, int par3) throws IOException {
        int index;
        FilterSlot slot;
        int index2;
        int i;
        super.func_73864_a(x, y, par3);
        for (i = 0; i < 8 && (index2 = i + this.te_router.gui_material_scroll) < this.material_slots.size(); ++i) {
            slot = this.material_slots.get(index2);
            if (!this.func_146978_c(111 + 17 * (i % 4), 24 + 17 * (i / 4), 16, 16, x, y)) continue;
            slot.onClick();
            return;
        }
        for (i = 0; i < 8 && (index2 = i + this.te_router.gui_type_scroll) < this.type_slots.size(); ++i) {
            slot = this.type_slots.get(index2);
            if (!this.func_146978_c(111 + 17 * (i % 4), 70 + 17 * (i / 4), 16, 16, x, y)) continue;
            slot.onClick();
            return;
        }
        List<TileEntityMaterialRouter.Route> routes = this.te_router.getRoutes();
        for (i = 0; i < 4 && (index = i + this.te_router.gui_route_scroll) < routes.size(); ++i) {
            if (!this.func_146978_c(81, 49 + i * 17 + 4, 8, 8, x, y)) continue;
            routes.remove(index);
            this.te_router.syncRoutes();
            return;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k < 6) {
            this.te_router.getRoutes().add(new TileEntityMaterialRouter.Route(this.material_slots.get(this.te_router.gui_material_selected).getName(), this.type_slots.get(this.te_router.gui_type_selected).getName(), EnumFacing.field_82609_l[button.field_146127_k]));
            this.te_router.syncRoutes();
        } else if (button.field_146127_k == this.material_scroll_left.field_146127_k) {
            if (this.te_router.gui_material_scroll > 0) {
                this.te_router.gui_material_scroll -= 8;
                this.do_scroll_sync = true;
            }
        } else if (button.field_146127_k == this.material_scroll_right.field_146127_k) {
            if (this.te_router.gui_material_scroll < this.material_slots.size() - 8) {
                this.te_router.gui_material_scroll += 8;
                this.do_scroll_sync = true;
            }
        } else if (button.field_146127_k == this.type_scroll_left.field_146127_k) {
            if (this.te_router.gui_type_scroll > 0) {
                this.te_router.gui_type_scroll -= 8;
                this.do_scroll_sync = true;
            }
        } else if (button.field_146127_k == this.type_scroll_right.field_146127_k) {
            if (this.te_router.gui_type_scroll < this.type_slots.size() - 8) {
                this.te_router.gui_type_scroll += 8;
                this.do_scroll_sync = true;
            }
        } else if (button.field_146127_k == this.route_scroll_up.field_146127_k) {
            if (this.te_router.gui_route_scroll > 0) {
                this.te_router.gui_route_scroll -= 4;
                this.do_scroll_sync = true;
            }
        } else if (button.field_146127_k == this.route_scroll_down.field_146127_k && this.te_router.gui_route_scroll < this.te_router.getRoutes().size() - 4) {
            this.te_router.gui_route_scroll += 4;
            this.do_scroll_sync = true;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int window_x = (this.field_146294_l - this.field_146999_f) / 2;
        int window_y = (this.field_146295_m - this.field_147000_g) / 2;
        this.route_buttons = new GuiButtonFoundry[6];
        for (int i = 0; i < 6; ++i) {
            this.route_buttons[i] = new GuiButtonFoundry(i, window_x + 119 + i % 3 * 18, window_y + 108 + i / 3 * 18, 16, 16, GUI_TEXTURE, 200, 177, 216, 177).setIconTexture(201, i * 16 + 1, 14, 14);
            this.field_146292_n.add(this.route_buttons[i]);
        }
        this.material_scroll_left = new GuiButtonFoundry(6, window_x + 96, window_y + 28, 12, 25, GUI_TEXTURE, 200, 99, 212, 99);
        this.field_146292_n.add(this.material_scroll_left);
        this.material_scroll_right = new GuiButtonFoundry(7, window_x + 181, window_y + 28, 12, 25, GUI_TEXTURE, 200, 124, 212, 124);
        this.field_146292_n.add(this.material_scroll_right);
        this.type_scroll_left = new GuiButtonFoundry(8, window_x + 96, window_y + 74, 12, 25, GUI_TEXTURE, 200, 99, 212, 99);
        this.field_146292_n.add(this.type_scroll_left);
        this.type_scroll_right = new GuiButtonFoundry(9, window_x + 181, window_y + 74, 12, 25, GUI_TEXTURE, 200, 124, 212, 124);
        this.field_146292_n.add(this.type_scroll_right);
        this.route_scroll_up = new GuiButtonFoundry(10, window_x + 47, window_y + 24, 25, 12, GUI_TEXTURE, 200, 149, 225, 149);
        this.field_146292_n.add(this.route_scroll_up);
        this.route_scroll_down = new GuiButtonFoundry(11, window_x + 47, window_y + 119, 25, 12, GUI_TEXTURE, 200, 161, 225, 161);
        this.field_146292_n.add(this.route_scroll_down);
    }

    public void func_146281_b() {
        if (this.do_scroll_sync) {
            this.te_router.syncRoutes();
        }
        super.func_146281_b();
    }

    @SideOnly(value=Side.CLIENT)
    private class FilterSlotType
    extends FilterSlot {
        public FilterSlotType(int slot_index, String filter_name) {
            super(slot_index, filter_name);
        }

        @Override
        public void draw(int x, int y) {
            GuiMaterialRouter.this.drawTypeIcon(x, y, this.name);
        }

        @Override
        public void drawTooltip(int x, int y) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(new TextComponentTranslation("foundry.router.type." + this.name, new Object[0]).func_150260_c());
            GuiMaterialRouter.this.drawHoveringText(tooltip, x, y, GuiMaterialRouter.this.field_146289_q);
        }

        @Override
        public void onClick() {
            ((GuiMaterialRouter)GuiMaterialRouter.this).te_router.gui_type_selected = this.index;
            GuiMaterialRouter.this.te_router.syncRoutes();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class FilterSlotMaterial
    extends FilterSlot {
        public FilterSlotMaterial(int slot_index, String filter_name) {
            super(slot_index, filter_name);
        }

        @Override
        public void draw(int x, int y) {
            GuiMaterialRouter.this.drawMaterialIcon(x, y, this.name);
        }

        @Override
        public void drawTooltip(int x, int y) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(new TextComponentTranslation("foundry.router.material." + this.name, new Object[0]).func_150260_c());
            GuiMaterialRouter.this.drawHoveringText(tooltip, x, y, GuiMaterialRouter.this.field_146289_q);
        }

        @Override
        public void onClick() {
            ((GuiMaterialRouter)GuiMaterialRouter.this).te_router.gui_material_selected = this.index;
            GuiMaterialRouter.this.te_router.syncRoutes();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private abstract class FilterSlot {
        protected final String name;
        protected final int index;

        public FilterSlot(int slot_index, String filter_name) {
            this.index = slot_index;
            this.name = filter_name;
        }

        public abstract void draw(int var1, int var2);

        public abstract void drawTooltip(int var1, int var2);

        public abstract void onClick();

        public final String getName() {
            return this.name;
        }
    }
}

