/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.fluid;

import exter.foundry.api.registry.IFluidRegistry;
import exter.foundry.block.BlockLiquidMetal;
import exter.foundry.block.FoundryBlocks;
import exter.foundry.fluid.FluidLiquidMetal;
import exter.foundry.util.FoundryMiscUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class LiquidMetalRegistry
implements IFluidRegistry {
    private Map<String, FluidLiquidMetal> registry = new HashMap<String, FluidLiquidMetal>();
    public static LiquidMetalRegistry instance = new LiquidMetalRegistry();

    private LiquidMetalRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public FluidLiquidMetal registerLiquidMetal(String metal_name, int temperature, int luminosity) {
        return this.registerLiquidMetal(metal_name, temperature, luminosity, "liquid" + metal_name, 0xFFFFFF);
    }

    public FluidLiquidMetal registerLiquidMetal(String metal_name, int temperature, int luminosity, String texture, int color) {
        FluidLiquidMetal fluid = new FluidLiquidMetal("liquid" + metal_name, new ResourceLocation("foundry", "blocks/" + texture + "_still"), new ResourceLocation("foundry", "blocks/" + texture + "_flow"), color, false, temperature, luminosity);
        FluidRegistry.registerFluid((Fluid)fluid);
        String block_name = "block" + metal_name;
        Object solid = FoundryMiscUtils.getModItemFromOreDictionary("substratum", block_name);
        if (solid == null) {
            solid = block_name;
        }
        BlockLiquidMetal liquid_block = new BlockLiquidMetal(fluid, "liquid" + metal_name, solid);
        FoundryBlocks.register((Block)liquid_block);
        fluid.setBlock((Block)liquid_block);
        this.registry.put(metal_name, fluid);
        return fluid;
    }

    public FluidLiquidMetal registerSpecialLiquidMetal(String metal_name, int temperature, int luminosity, ItemStack solid) {
        return this.registerSpecialLiquidMetal(metal_name, temperature, luminosity, "liquid" + metal_name, 0xFFFFFF, solid);
    }

    public FluidLiquidMetal registerSpecialLiquidMetal(String metal_name, int temperature, int luminosity, String texture, int color, ItemStack solid) {
        FluidLiquidMetal fluid = new FluidLiquidMetal("liquid" + metal_name, new ResourceLocation("foundry", "blocks/" + texture + "_still"), new ResourceLocation("foundry", "blocks/" + texture + "_flow"), color, true, temperature, luminosity);
        FluidRegistry.registerFluid((Fluid)fluid);
        BlockLiquidMetal liquid_block = new BlockLiquidMetal(fluid, "liquid" + metal_name, solid);
        FoundryBlocks.register((Block)liquid_block);
        fluid.setBlock((Block)liquid_block);
        this.registry.put(metal_name, fluid);
        return fluid;
    }

    @Override
    public FluidLiquidMetal getFluid(String name) {
        return this.registry.get(name);
    }

    public Map<String, FluidLiquidMetal> getFluids() {
        return Collections.unmodifiableMap(this.registry);
    }

    public Set<String> getFluidNames() {
        return Collections.unmodifiableSet(this.registry.keySet());
    }
}

