/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.block;

import exter.foundry.block.BlockAlloyFurnace;
import exter.foundry.block.BlockBurnerHeater;
import exter.foundry.block.BlockCastingTable;
import exter.foundry.block.BlockCokeOven;
import exter.foundry.block.BlockComponent;
import exter.foundry.block.BlockFoundryMachine;
import exter.foundry.block.BlockInfernoTank;
import exter.foundry.block.BlockMoldStation;
import exter.foundry.block.BlockRefractoryGlass;
import exter.foundry.block.BlockRefractoryHopper;
import exter.foundry.block.BlockRefractorySpout;
import exter.foundry.block.BlockRefractoryTank;
import exter.foundry.config.FoundryConfig;
import exter.foundry.item.ItemBlockMulti;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FoundryBlocks {
    public static BlockComponent block_component;
    public static BlockRefractoryGlass block_refractory_glass;
    public static BlockFoundryMachine block_machine;
    public static BlockCastingTable block_casting_table;
    public static BlockAlloyFurnace block_alloy_furnace;
    public static BlockMoldStation block_mold_station;
    public static BlockBurnerHeater block_burner_heater;
    public static BlockCokeOven block_coke_oven;
    public static BlockRefractoryHopper block_refractory_hopper;
    public static BlockRefractorySpout block_refractory_spout;
    public static BlockRefractoryTank block_refractory_tank;
    public static BlockInfernoTank block_inferno_tank;

    public static void register(Block block) {
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    private static <T extends Block> void registerMulti(T block) {
        GameRegistry.register(block);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockMulti(block).setRegistryName(block.getRegistryName()));
    }

    public static void registerBlocks(Configuration config) {
        block_component = new BlockComponent();
        block_refractory_glass = new BlockRefractoryGlass();
        block_machine = new BlockFoundryMachine();
        block_casting_table = new BlockCastingTable();
        block_alloy_furnace = new BlockAlloyFurnace();
        block_mold_station = new BlockMoldStation();
        block_refractory_hopper = new BlockRefractoryHopper();
        block_burner_heater = new BlockBurnerHeater();
        block_refractory_spout = new BlockRefractorySpout();
        block_refractory_tank = new BlockRefractoryTank();
        block_inferno_tank = new BlockInfernoTank();
        FoundryBlocks.registerMulti(block_component);
        FoundryBlocks.registerMulti(block_machine);
        FoundryBlocks.registerMulti(block_casting_table);
        FoundryBlocks.register((Block)block_refractory_glass);
        FoundryBlocks.register((Block)block_alloy_furnace);
        FoundryBlocks.register((Block)block_mold_station);
        FoundryBlocks.register((Block)block_refractory_hopper);
        FoundryBlocks.register((Block)block_burner_heater);
        FoundryBlocks.register((Block)block_refractory_spout);
        FoundryBlocks.register((Block)block_refractory_tank);
        FoundryBlocks.register((Block)block_inferno_tank);
        if (FoundryConfig.block_cokeoven) {
            block_coke_oven = new BlockCokeOven();
            FoundryBlocks.register((Block)block_coke_oven);
        }
    }
}

