/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.block;

import exter.foundry.ModFoundry;
import exter.foundry.creativetab.FoundryTabMachines;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityRefractoryHopper;
import exter.foundry.tileentity.renderer.ISpoutPourDepth;
import exter.foundry.util.FoundryMiscUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRefractoryHopper
extends BlockContainer
implements ISpoutPourDepth {
    public static final PropertyEnum<EnumHopperFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumHopperFacing.class);
    protected static final AxisAlignedBB AABB_SIDES = new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
    private Random rand = new Random();
    protected static final AxisAlignedBB[] BOUNDS = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0), new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0)};

    public BlockRefractoryHopper() {
        super(Material.field_151573_f);
        this.func_149647_a(FoundryTabMachines.tab);
        this.func_149711_c(1.0f);
        this.func_149752_b(8.0f);
        this.func_149663_c("foundry.refractoryHopper");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)((Object)EnumHopperFacing.DOWN)));
        this.setRegistryName("refractoryHopper");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(FACING) == EnumHopperFacing.DOWN ? field_185505_j : AABB_SIDES;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        for (AxisAlignedBB box : BOUNDS) {
            BlockRefractoryHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumHopperFacing.fromID(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumHopperFacing)((Object)state.func_177229_b(BlockRefractoryHopper.FACING))).id;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        switch (facing) {
            case EAST: {
                return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumHopperFacing.WEST));
            }
            case NORTH: {
                return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumHopperFacing.SOUTH));
            }
            case SOUTH: {
                return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumHopperFacing.NORTH));
            }
            case WEST: {
                return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumHopperFacing.EAST));
            }
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumHopperFacing.DOWN));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityRefractoryHopper();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        TileEntityFoundry te = (TileEntityFoundry)world.func_175625_s(pos);
        if (te != null) {
            te.updateRedstone();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing side, float hitx, float hity, float hitz) {
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)ModFoundry.instance, 6, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityFoundry && !world.field_72995_K) {
            TileEntityFoundry tef = (TileEntityFoundry)te;
            for (int i = 0; i < tef.func_70302_i_(); ++i) {
                ItemStack is = tef.func_70301_a(i);
                if (is == null || is.field_77994_a <= 0) continue;
                double drop_x = (double)this.rand.nextFloat() * 0.3 + 0.35;
                double drop_y = (double)this.rand.nextFloat() * 0.3 + 0.35;
                double drop_z = (double)this.rand.nextFloat() * 0.3 + 0.35;
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + drop_x, (double)pos.func_177956_o() + drop_y, (double)pos.func_177952_p() + drop_z, is);
                entityitem.func_174867_a(10);
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getSpoutPourDepth(World world, BlockPos pos, IBlockState state) {
        return 11;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        FoundryMiscUtils.localizeTooltip("tooltip.foundry.refractoryHopper", tooltip);
    }

    public static enum EnumHopperFacing implements IStringSerializable
    {
        NORTH(0, "north", EnumFacing.NORTH),
        SOUTH(1, "south", EnumFacing.SOUTH),
        EAST(2, "east", EnumFacing.EAST),
        WEST(3, "west", EnumFacing.WEST),
        DOWN(4, "down", EnumFacing.DOWN);

        public final int id;
        public final String name;
        public final EnumFacing facing;

        private EnumHopperFacing(int id, String name, EnumFacing target) {
            this.id = id;
            this.name = name;
            this.facing = target;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public static EnumHopperFacing fromID(int num) {
            for (EnumHopperFacing m : EnumHopperFacing.values()) {
                if (m.id != num) continue;
                return m;
            }
            return null;
        }
    }
}

