/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.block;

import exter.foundry.creativetab.FoundryTabFluids;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class BlockLiquidMetal
extends BlockFluidClassic {
    private Object solid;
    private IBlockState solid_state = null;

    public BlockLiquidMetal(Fluid fluid, String name, Object solid_block) {
        super(fluid, Material.field_151587_i);
        this.func_149713_g(0);
        this.func_149715_a(1.0f);
        this.solid = solid_block;
        this.func_149663_c(name);
        this.func_149647_a(FoundryTabFluids.tab);
        this.setRegistryName(name);
    }

    public String func_149739_a() {
        return this.stack.getUnlocalizedName();
    }

    public String func_149732_F() {
        return this.stack.getLocalizedName();
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 300;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double dz;
        double dy;
        double dx;
        if (this.temperature < 1200) {
            return;
        }
        if (world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_185914_p()) {
            if (rand.nextInt(100) == 0) {
                dx = (float)pos.func_177958_n() + rand.nextFloat();
                dy = (double)pos.func_177956_o() + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e;
                dz = (float)pos.func_177952_p() + rand.nextFloat();
                world.func_175688_a(EnumParticleTypes.LAVA, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
                world.func_184134_a(dx, dy, dz, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
        BlockPos down = pos.func_177977_b();
        if (rand.nextInt(10) == 0 && world.func_180495_p(down).isSideSolid((IBlockAccess)world, down, EnumFacing.UP) && !world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_185904_a().func_76230_c()) {
            dx = (float)pos.func_177958_n() + rand.nextFloat();
            dy = (double)pos.func_177956_o() - 1.05;
            dz = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.DRIP_LAVA, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.checkForHarden(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        super.func_189540_a(state, world, pos, block);
        this.checkForHarden(world, pos, state);
    }

    private IBlockState getBlockStateFromItemStack(ItemStack stack) {
        Block block = ((ItemBlock)stack.func_77973_b()).field_150939_a;
        int meta = stack.func_77960_j();
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            if (state == null || block.func_180651_a(state) != meta) continue;
            return state;
        }
        return null;
    }

    public void checkForHarden(World world, BlockPos pos, IBlockState state) {
        if (this.isSourceBlock((IBlockAccess)world, pos)) {
            if (this.solid_state == null && this.solid != null) {
                ItemStack item = null;
                if (this.solid instanceof ItemStack) {
                    item = (ItemStack)this.solid;
                } else if (this.solid instanceof String) {
                    for (ItemStack i : OreDictionary.getOres((String)((String)this.solid))) {
                        if (!(i.func_77973_b() instanceof ItemBlock)) continue;
                        item = i;
                        break;
                    }
                } else {
                    this.solid = null;
                }
                if (item == null) {
                    this.solid = null;
                }
                this.solid_state = this.getBlockStateFromItemStack(item);
            }
            if (this.solid_state == null) {
                return;
            }
            if (this.tryToHarden(world, pos, pos.func_177982_a(-1, 0, 0))) {
                return;
            }
            if (this.tryToHarden(world, pos, pos.func_177982_a(1, 0, 0))) {
                return;
            }
            if (this.tryToHarden(world, pos, pos.func_177982_a(0, -1, 0))) {
                return;
            }
            if (this.tryToHarden(world, pos, pos.func_177982_a(0, 1, 0))) {
                return;
            }
            if (this.tryToHarden(world, pos, pos.func_177982_a(0, 0, -1))) {
                return;
            }
            if (this.tryToHarden(world, pos, pos.func_177982_a(0, 0, 1))) {
                return;
            }
        }
    }

    private boolean tryToHarden(World world, BlockPos pos, BlockPos npos) {
        if (world.func_180495_p(npos).func_185904_a() == Material.field_151586_h) {
            world.func_175656_a(pos, this.solid_state);
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f, false);
            for (int i = 0; i < 8; ++i) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
            return true;
        }
        return false;
    }

    public void func_180634_a(World wWorld, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            entity.field_70159_w *= 0.5;
            entity.field_70179_y *= 0.5;
        }
        if (!entity.func_70045_F()) {
            if (!(entity instanceof EntityItem)) {
                entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
            }
            entity.func_70015_d(15);
        }
    }
}

