/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.block;

import exter.foundry.ModFoundry;
import exter.foundry.block.IBlockVariants;
import exter.foundry.creativetab.FoundryTabMachines;
import exter.foundry.tileentity.TileEntityAlloyMixer;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityInductionHeater;
import exter.foundry.tileentity.TileEntityMaterialRouter;
import exter.foundry.tileentity.TileEntityMeltingCrucible;
import exter.foundry.tileentity.TileEntityMeltingCrucibleAdvanced;
import exter.foundry.tileentity.TileEntityMetalAtomizer;
import exter.foundry.tileentity.TileEntityMetalCaster;
import exter.foundry.tileentity.TileEntityMetalInfuser;
import exter.foundry.util.FoundryMiscUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFoundryMachine
extends Block
implements ITileEntityProvider,
IBlockVariants {
    private Random rand = new Random();
    public static final PropertyEnum<EnumMachine> MACHINE = PropertyEnum.func_177709_a((String)"machine", EnumMachine.class);

    public BlockFoundryMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("foundry.machine");
        this.func_149647_a(FoundryTabMachines.tab);
        this.setRegistryName("machine");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MACHINE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(MACHINE, (Comparable)((Object)EnumMachine.fromID(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachine)((Object)state.func_177229_b(BlockFoundryMachine.MACHINE))).id;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityFoundry && !world.field_72995_K) {
            TileEntityFoundry tef = (TileEntityFoundry)te;
            for (int i = 0; i < tef.func_70302_i_(); ++i) {
                ItemStack is = tef.func_70301_a(i);
                if (is == null || is.field_77994_a <= 0) continue;
                double drop_x = (double)this.rand.nextFloat() * 0.3 + 0.35;
                double drop_y = (double)this.rand.nextFloat() * 0.3 + 0.35;
                double drop_z = (double)this.rand.nextFloat() * 0.3 + 0.35;
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + drop_x, (double)pos.func_177956_o() + drop_y, (double)pos.func_177952_p() + drop_z, is);
                entityitem.func_174867_a(10);
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing side, float hit_x, float hit_y, float hit_z) {
        if (world.field_72995_K) {
            return true;
        }
        switch ((EnumMachine)((Object)state.func_177229_b(MACHINE))) {
            case CRUCIBLE: 
            case ADVCRUCIBLE: {
                player.openGui((Object)ModFoundry.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                break;
            }
            case CASTER: {
                player.openGui((Object)ModFoundry.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                break;
            }
            case ALLOYMIXER: {
                player.openGui((Object)ModFoundry.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                break;
            }
            case INFUSER: {
                player.openGui((Object)ModFoundry.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                break;
            }
            case MATERIALROUTER: {
                player.openGui((Object)ModFoundry.instance, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                break;
            }
            case ATOMIZER: {
                player.openGui((Object)ModFoundry.instance, 9, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((EnumMachine)((Object)state.func_177229_b(MACHINE))) {
            case CRUCIBLE: {
                return new TileEntityMeltingCrucible();
            }
            case CASTER: {
                return new TileEntityMetalCaster();
            }
            case ALLOYMIXER: {
                return new TileEntityAlloyMixer();
            }
            case INFUSER: {
                return new TileEntityMetalInfuser();
            }
            case MATERIALROUTER: {
                return new TileEntityMaterialRouter();
            }
            case ATOMIZER: {
                return new TileEntityMetalAtomizer();
            }
            case INDUCTIONHEATER: {
                return new TileEntityInductionHeater();
            }
            case ADVCRUCIBLE: {
                return new TileEntityMeltingCrucibleAdvanced();
            }
        }
        return null;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumMachine m : EnumMachine.values()) {
            list.add(new ItemStack(item, 1, m.id));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        TileEntityFoundry te = (TileEntityFoundry)world.func_175625_s(pos);
        if (te != null) {
            te.updateRedstone();
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTileEntity(world, this.func_176203_a(meta));
    }

    @Override
    public String getUnlocalizedName(int meta) {
        return this.func_149739_a() + "." + ((EnumMachine)((Object)this.func_176203_a((int)meta).func_177229_b(BlockFoundryMachine.MACHINE))).name;
    }

    public ItemStack asItemStack(EnumMachine machine) {
        return new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(MACHINE, (Comparable)((Object)machine))));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        FoundryMiscUtils.localizeTooltip("tooltip.foundry.machine." + ((EnumMachine)((Object)this.func_176203_a((int)stack.func_77960_j()).func_177229_b(BlockFoundryMachine.MACHINE))).name, tooltip);
    }

    public static enum EnumMachine implements IStringSerializable
    {
        CRUCIBLE(0, "crucible", "machineCrucible"),
        CASTER(1, "caster", "machineCaster"),
        ALLOYMIXER(2, "alloymixer", "machineAlloyMixer"),
        INFUSER(3, "infuser", "machineInfuser"),
        MATERIALROUTER(4, "router", "machineMaterialRouter"),
        ATOMIZER(5, "atomizer", "machineAtomizer"),
        INDUCTIONHEATER(6, "heater_induction", "machineInductionHeater"),
        ADVCRUCIBLE(7, "crucible_advanced", "machineCrucibleAdvanced");

        public final int id;
        public final String name;
        public final String model;

        private EnumMachine(int id, String name, String model) {
            this.id = id;
            this.name = name;
            this.model = model;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public static EnumMachine fromID(int num) {
            for (EnumMachine m : EnumMachine.values()) {
                if (m.id != num) continue;
                return m;
            }
            return null;
        }
    }
}

