/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.block;

import exter.foundry.block.IBlockVariants;
import exter.foundry.creativetab.FoundryTabMachines;
import exter.foundry.tileentity.TileEntityCastingTableBase;
import exter.foundry.tileentity.TileEntityCastingTableBlock;
import exter.foundry.tileentity.TileEntityCastingTableIngot;
import exter.foundry.tileentity.TileEntityCastingTablePlate;
import exter.foundry.tileentity.TileEntityCastingTableRod;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.renderer.ISpoutPourDepth;
import exter.foundry.util.FoundryMiscUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCastingTable
extends Block
implements ITileEntityProvider,
IBlockVariants,
ISpoutPourDepth {
    private Random rand = new Random();
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    protected static final AxisAlignedBB AABB_BLOCK = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    public static final PropertyEnum<EnumTable> TABLE = PropertyEnum.func_177709_a((String)"type", EnumTable.class);

    public BlockCastingTable() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("foundry.castingTable");
        this.func_149647_a(FoundryTabMachines.tab);
        this.setRegistryName("castingTable");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TABLE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TABLE, (Comparable)((Object)EnumTable.fromID(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumTable)((Object)state.func_177229_b(BlockCastingTable.TABLE))).id;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(TABLE) == EnumTable.BLOCK) {
            return AABB_BLOCK;
        }
        return AABB;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ItemStack is;
        TileEntityCastingTableBase tef;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCastingTableBase && !world.field_72995_K && (tef = (TileEntityCastingTableBase)te).getProgress() == 0 && (is = tef.func_70301_a(0)) != null && is.field_77994_a > 0) {
            double drop_x = (double)this.rand.nextFloat() * 0.3 + 0.35;
            double drop_y = (double)this.rand.nextFloat() * 0.3 + 0.35;
            double drop_z = (double)this.rand.nextFloat() * 0.3 + 0.35;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + drop_x, (double)pos.func_177956_o() + drop_y, (double)pos.func_177952_p() + drop_z, is);
            entityitem.func_174867_a(10);
            world.func_72838_d((Entity)entityitem);
        }
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    private void dropCastingTableOutput(World world, BlockPos pos, IBlockState state) {
        ItemStack is;
        TileEntityCastingTableBase te_ct;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCastingTableBase && !world.field_72995_K && (te_ct = (TileEntityCastingTableBase)te).getProgress() == 0 && (is = te_ct.func_70301_a(0)) != null && is.field_77994_a > 0) {
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.9375, (double)pos.func_177952_p() + 0.5, is);
            entityitem.func_174867_a(1);
            world.func_72838_d((Entity)entityitem);
            te_ct.func_70299_a(0, null);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing side, float hit_x, float hit_y, float hit_z) {
        if (world.field_72995_K) {
            return true;
        }
        this.dropCastingTableOutput(world, pos, state);
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((EnumTable)((Object)state.func_177229_b(TABLE))) {
            case INGOT: {
                return new TileEntityCastingTableIngot();
            }
            case PLATE: {
                return new TileEntityCastingTablePlate();
            }
            case ROD: {
                return new TileEntityCastingTableRod();
            }
            case BLOCK: {
                return new TileEntityCastingTableBlock();
            }
        }
        return null;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumTable m : EnumTable.values()) {
            list.add(new ItemStack(item, 1, m.id));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        TileEntityFoundry te = (TileEntityFoundry)world.func_175625_s(pos);
        if (te != null) {
            te.updateRedstone();
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTileEntity(world, this.func_176203_a(meta));
    }

    @Override
    public String getUnlocalizedName(int meta) {
        return this.func_149739_a() + "." + ((EnumTable)((Object)this.func_176203_a((int)meta).func_177229_b(BlockCastingTable.TABLE))).name;
    }

    public ItemStack asItemStack(EnumTable machine) {
        return new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TABLE, (Comparable)((Object)machine))));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getSpoutPourDepth(World world, BlockPos pos, IBlockState state) {
        return ((EnumTable)((Object)state.func_177229_b(BlockCastingTable.TABLE))).depth;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        FoundryMiscUtils.localizeTooltip("tooltip.foundry.castingTable." + ((EnumTable)((Object)this.func_176203_a((int)stack.func_77960_j()).func_177229_b(BlockCastingTable.TABLE))).name, tooltip);
    }

    public static enum EnumTable implements IStringSerializable
    {
        INGOT(0, "ingot", "castingTableIngot", 9),
        PLATE(1, "plate", "castingTablePlate", 11),
        ROD(2, "rod", "castingTableRod", 10),
        BLOCK(3, "block", "castingTableBlock", 2);

        public final int id;
        public final String name;
        public final String model;
        public final int depth;

        private EnumTable(int id, String name, String model, int depth) {
            this.id = id;
            this.name = name;
            this.model = model;
            this.depth = depth;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public static EnumTable fromID(int num) {
            for (EnumTable m : EnumTable.values()) {
                if (m.id != num) continue;
                return m;
            }
            return null;
        }
    }
}

