/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.api.recipe.matcher;

import exter.foundry.api.FoundryUtils;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreMatcher
implements IItemMatcher {
    private String match;
    private int amount;

    public OreMatcher(String match) {
        this(match, 1);
    }

    public OreMatcher(String match, int amount) {
        if (amount < 1) {
            throw new IllegalArgumentException("Amount must be > 1");
        }
        this.match = match;
        this.amount = amount;
    }

    public boolean apply(ItemStack input) {
        return FoundryUtils.isItemInOreDictionary(this.match, input) && input.field_77994_a >= this.amount;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    public String getOreName() {
        return this.match;
    }

    @Override
    public List<ItemStack> getItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack ore : OreDictionary.getOres((String)this.match)) {
            ore = ore.func_77946_l();
            ore.field_77994_a = this.amount;
            list.add(ore);
        }
        return list;
    }

    @Override
    public ItemStack getItem() {
        List list = OreDictionary.getOres((String)this.match);
        if (list.isEmpty()) {
            return null;
        }
        ItemStack res = ((ItemStack)list.get(0)).func_77946_l();
        res.field_77994_a = this.amount;
        return res;
    }
}

