/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry;

import exter.foundry.api.FoundryAPI;
import exter.foundry.block.FoundryBlocks;
import exter.foundry.capability.CapabilityFirearmRound;
import exter.foundry.capability.CapabilityHeatProvider;
import exter.foundry.config.FoundryConfig;
import exter.foundry.entity.EntitySkeletonGun;
import exter.foundry.fluid.FoundryFluids;
import exter.foundry.fluid.LiquidMetalRegistry;
import exter.foundry.init.InitRecipes;
import exter.foundry.integration.ModIntegrationBotania;
import exter.foundry.integration.ModIntegrationEnderIO;
import exter.foundry.integration.ModIntegrationManager;
import exter.foundry.integration.ModIntegrationMinetweaker;
import exter.foundry.integration.ModIntegrationMolten;
import exter.foundry.integration.ModIntegrationTiCon;
import exter.foundry.item.FoundryItems;
import exter.foundry.network.MessageTileEntitySync;
import exter.foundry.proxy.CommonFoundryProxy;
import exter.foundry.recipes.manager.AlloyFurnaceRecipeManager;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import exter.foundry.recipes.manager.AtomizerRecipeManager;
import exter.foundry.recipes.manager.BurnerHeaterFuelManager;
import exter.foundry.recipes.manager.CastingRecipeManager;
import exter.foundry.recipes.manager.CastingTableRecipeManager;
import exter.foundry.recipes.manager.InfuserRecipeManager;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import exter.foundry.recipes.manager.MoldRecipeManager;
import exter.foundry.sound.FoundrySounds;
import exter.foundry.tileentity.TileEntityAlloyFurnace;
import exter.foundry.tileentity.TileEntityAlloyMixer;
import exter.foundry.tileentity.TileEntityBurnerHeater;
import exter.foundry.tileentity.TileEntityCastingTableBlock;
import exter.foundry.tileentity.TileEntityCastingTableIngot;
import exter.foundry.tileentity.TileEntityCastingTablePlate;
import exter.foundry.tileentity.TileEntityCastingTableRod;
import exter.foundry.tileentity.TileEntityCokeOven;
import exter.foundry.tileentity.TileEntityInductionHeater;
import exter.foundry.tileentity.TileEntityInfernoTank;
import exter.foundry.tileentity.TileEntityMaterialRouter;
import exter.foundry.tileentity.TileEntityMeltingCrucible;
import exter.foundry.tileentity.TileEntityMeltingCrucibleAdvanced;
import exter.foundry.tileentity.TileEntityMetalAtomizer;
import exter.foundry.tileentity.TileEntityMetalCaster;
import exter.foundry.tileentity.TileEntityMetalInfuser;
import exter.foundry.tileentity.TileEntityMoldStation;
import exter.foundry.tileentity.TileEntityRefractoryHopper;
import exter.foundry.tileentity.TileEntityRefractorySpout;
import exter.foundry.tileentity.TileEntityRefractoryTank;
import java.util.ArrayList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="foundry", name="Foundry", version="2.1.0.1", dependencies="required-after:Forge@[12.18.0.2005,);required-after:substratum@[1.7.0.0,)", acceptedMinecraftVersions="[1.10.2]")
public class ModFoundry {
    public static final String MODID = "foundry";
    public static final String MODNAME = "Foundry";
    public static final String MODVERSION = "2.1.0.1";
    @Mod.Instance(value="foundry")
    public static ModFoundry instance;
    @SidedProxy(clientSide="exter.foundry.proxy.ClientFoundryProxy", serverSide="exter.foundry.proxy.CommonFoundryProxy")
    public static CommonFoundryProxy proxy;
    public static Logger log;
    public static SimpleNetworkWrapper network_channel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        ModIntegrationManager.registerIntegration(config, new ModIntegrationMinetweaker());
        ModIntegrationManager.registerIntegration(config, new ModIntegrationTiCon());
        ModIntegrationManager.registerIntegration(config, new ModIntegrationMolten());
        ModIntegrationManager.registerIntegration(config, new ModIntegrationEnderIO());
        ModIntegrationManager.registerIntegration(config, new ModIntegrationBotania());
        FoundryAPI.fluids = LiquidMetalRegistry.instance;
        FoundryAPI.recipes_melting = MeltingRecipeManager.instance;
        FoundryAPI.recipes_casting = CastingRecipeManager.instance;
        FoundryAPI.recipes_casting_table = CastingTableRecipeManager.instance;
        FoundryAPI.recipes_alloymixer = AlloyMixerRecipeManager.instance;
        FoundryAPI.recipes_infuser = InfuserRecipeManager.instance;
        FoundryAPI.recipes_alloyfurnace = AlloyFurnaceRecipeManager.instance;
        FoundryAPI.recipes_atomizer = AtomizerRecipeManager.instance;
        FoundryAPI.recipes_mold = MoldRecipeManager.instance;
        FoundryAPI.burnerheater_fuel = BurnerHeaterFuelManager.instance;
        CapabilityHeatProvider.init();
        CapabilityFirearmRound.init();
        FoundryConfig.load(config);
        FoundryItems.registerItems(config);
        FoundryBlocks.registerBlocks(config);
        FoundryFluids.init();
        InitRecipes.preInit();
        ModIntegrationManager.preInit(config);
        config.save();
        network_channel = NetworkRegistry.INSTANCE.newSimpleChannel("EXTER.FOUNDRY");
        network_channel.registerMessage(MessageTileEntitySync.Handler.class, MessageTileEntitySync.class, 0, Side.SERVER);
        network_channel.registerMessage(MessageTileEntitySync.Handler.class, MessageTileEntitySync.class, 0, Side.CLIENT);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        ModIntegrationManager.init();
        FoundrySounds.init();
        GameRegistry.registerTileEntity(TileEntityMeltingCrucible.class, (String)"Foundry_MeltingCrucible");
        GameRegistry.registerTileEntity(TileEntityMetalCaster.class, (String)"Foundry_MetalCaster");
        GameRegistry.registerTileEntity(TileEntityAlloyMixer.class, (String)"Foundry_AlloyMixer");
        GameRegistry.registerTileEntity(TileEntityMetalInfuser.class, (String)"Foundry_MetalInfuser");
        GameRegistry.registerTileEntity(TileEntityAlloyFurnace.class, (String)"Foundry_AlloyFurnace");
        GameRegistry.registerTileEntity(TileEntityMoldStation.class, (String)"Foundry_MoldStation");
        GameRegistry.registerTileEntity(TileEntityMaterialRouter.class, (String)"Foundry_MaterialRouter");
        GameRegistry.registerTileEntity(TileEntityRefractoryHopper.class, (String)"Foundry_RefractoryHopper");
        GameRegistry.registerTileEntity(TileEntityMetalAtomizer.class, (String)"Foundry_MetalAtomizer");
        GameRegistry.registerTileEntity(TileEntityInductionHeater.class, (String)"Foundry_InductionHeater");
        GameRegistry.registerTileEntity(TileEntityBurnerHeater.class, (String)"Foundry_BurnerHeater");
        GameRegistry.registerTileEntity(TileEntityCastingTableIngot.class, (String)"Foundry_CastingTable_Ingot");
        GameRegistry.registerTileEntity(TileEntityCastingTablePlate.class, (String)"Foundry_CastingTable_Plate");
        GameRegistry.registerTileEntity(TileEntityCastingTableRod.class, (String)"Foundry_CastingTable_Rod");
        GameRegistry.registerTileEntity(TileEntityCastingTableBlock.class, (String)"Foundry_CastingTable_Block");
        GameRegistry.registerTileEntity(TileEntityRefractorySpout.class, (String)"Foundry_RefractorySpout");
        GameRegistry.registerTileEntity(TileEntityMeltingCrucibleAdvanced.class, (String)"Foundry_MeltingCrucibleAdvanced");
        GameRegistry.registerTileEntity(TileEntityRefractoryTank.class, (String)"Foundry_RefractoryTank");
        GameRegistry.registerTileEntity(TileEntityInfernoTank.class, (String)"Foundry_InfernoTank");
        if (FoundryConfig.block_cokeoven) {
            GameRegistry.registerTileEntity(TileEntityCokeOven.class, (String)"Foundry_CokeOven");
        }
        InitRecipes.init();
        EntityRegistry.registerModEntity(EntitySkeletonGun.class, (String)"gunSkeleton", (int)0, (Object)this, (int)80, (int)1, (boolean)true);
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "gun_skeleton"));
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (BiomeDictionary.Type type : BiomeDictionary.Type.values()) {
            for (Biome bio : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                if (biomes.contains(bio)) continue;
                biomes.add(bio);
            }
        }
        for (BiomeDictionary.Type type : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            if (!biomes.contains(type)) continue;
            biomes.remove(type);
        }
        for (BiomeDictionary.Type type : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            if (!biomes.contains(type)) continue;
            biomes.remove(type);
        }
        ArrayList<Biome> toremove = new ArrayList<Biome>();
        for (Biome bio : biomes) {
            boolean bl = true;
            for (Biome.SpawnListEntry e : bio.func_76747_a(EnumCreatureType.MONSTER)) {
                if (e.field_76300_b != EntitySkeleton.class) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            toremove.add(bio);
        }
        biomes.removeAll(toremove);
        EntityRegistry.addSpawn(EntitySkeletonGun.class, (int)8, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes.toArray(new Biome[0]));
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModIntegrationManager.postInit();
        InitRecipes.postInit();
        proxy.postInit();
        ModIntegrationManager.afterPostInit();
    }

    static {
        log = LogManager.getLogger((String)MODNAME);
    }
}

