/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.items;

import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thut.api.ThutItems;
import thut.core.common.ThutCore;

public class ItemTank
extends Item
implements IFluidContainerItem {
    public ItemTank() {
        this.func_77627_a(false);
        this.func_77655_b("tank");
        this.func_77637_a(ThutCore.tabThut);
        ThutItems.tank = this;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        int exist = this.getAmount(container);
        int amount = Math.min(maxDrain, exist);
        FluidStack fluid = this.getFluid(container);
        if (fluid == null) {
            return null;
        }
        String name = container.func_77978_p().func_74779_i("fluidName");
        NBTTagCompound tag = container.func_77978_p().func_74775_l("fluidTag");
        if (tag.func_82582_d()) {
            tag = null;
        }
        if (doDrain) {
            name = fluid.getUnlocalizedName();
            if (name.contains("tile.")) {
                name = name.replace("fluid.", "");
            }
            name = I18n.func_74838_a((String)(name + ".name"));
            container.func_77978_p().func_74768_a("fluidAmount", exist - amount);
            container.func_151001_c("Tank of " + name + " " + (exist - amount));
            if (exist - amount <= 0) {
                container.func_77982_d(null);
                container.func_151001_c("Empty Tank");
            }
        }
        return new FluidStack(FluidRegistry.getFluid((String)name), amount, tag);
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        int amount = resource.amount;
        int exist = this.getAmount(container);
        exist = Math.min(exist, 64000);
        int ret = 0;
        ret = amount + exist <= 64000 ? amount : 64000 - exist;
        if (doFill) {
            if (!container.func_77942_o()) {
                container.func_77982_d(new NBTTagCompound());
                container.func_77978_p().func_74778_a("fluidName", FluidRegistry.getFluidName((FluidStack)resource));
                container.func_77978_p().func_74768_a("fluidAmount", 0);
            }
            String name = container.func_77978_p().func_74779_i("fluidName");
            int amt = container.func_77978_p().func_74762_e("fluidAmount");
            if (name == null || name.trim().isEmpty()) {
                name = FluidRegistry.getFluidName((FluidStack)resource);
                container.func_77978_p().func_74778_a("fluidName", name);
                amt = 0;
                container.func_77978_p().func_74768_a("fluidAmount", 0);
                if (resource.tag != null) {
                    container.func_77978_p().func_74782_a("fluidTag", (NBTBase)resource.tag);
                }
            } else if (!this.getFluid(container).isFluidEqual(resource)) {
                return 0;
            }
            if ((name = resource.getUnlocalizedName()).contains("tile.")) {
                name = name.replace("fluid.", "");
            }
            name = I18n.func_74838_a((String)(name + ".name"));
            container.func_77978_p().func_74768_a("fluidAmount", amt + amount);
            container.func_151001_c("Tank of " + name + " " + (amt + amount));
        }
        return ret;
    }

    public int getAmount(ItemStack container) {
        if (this.getFluid(container) != null) {
            return this.getFluid((ItemStack)container).amount;
        }
        return 0;
    }

    public int getCapacity(ItemStack container) {
        if (container.func_77973_b() == this) {
            return 64000;
        }
        return 0;
    }

    public FluidStack getFluid(ItemStack container) {
        if (!container.func_77942_o()) {
            return null;
        }
        String name = container.func_77978_p().func_74779_i("fluidName");
        int amount = container.func_77978_p().func_74762_e("fluidAmount");
        NBTTagCompound tag = container.func_77978_p().func_74775_l("fluidTag");
        if (tag.func_82582_d()) {
            tag = null;
        }
        if (FluidRegistry.getFluid((String)name) == null) {
            return null;
        }
        FluidStack ret = new FluidStack(FluidRegistry.getFluid((String)name), amount, tag);
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack tank = new ItemStack(par1, 1, 0);
        tank.func_151001_c("Empty Tank");
        par3List.add(tank);
        Map fluidMap = FluidRegistry.getRegisteredFluids();
        for (Fluid f : fluidMap.values()) {
            if (f.getDensity() == Integer.MAX_VALUE || f.getViscosity() == Integer.MAX_VALUE) continue;
            tank = new ItemStack(par1, 1, 0);
            FluidStack fstack = new FluidStack(f, Integer.MAX_VALUE);
            this.fill(tank, fstack, true);
            par3List.add(tank);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer player, EnumHand hand) {
        return super.func_77659_a(itemstack, world, player, hand);
    }
}

