/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.items;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidContainerItem;
import thut.api.ThutItems;
import thut.api.maths.ExplosionCustom;
import thut.api.maths.Vector3;
import thut.core.common.ThutCore;

public class ItemSpout
extends Item {
    public ItemSpout() {
        this.func_77627_a(true);
        this.func_77655_b("spout");
        this.func_77637_a(ThutCore.tabThut);
        ThutItems.spout = this;
    }

    public ArrayList<ItemStack> getTanks(EntityPlayer player) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            IFluidContainerItem tank;
            if (stack == null || !(stack.func_77973_b() instanceof IFluidContainerItem) || (tank = (IFluidContainerItem)stack.func_77973_b()).getFluid(stack) == null) continue;
            ret.add(stack);
        }
        return ret;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer player, EnumHand hand) {
        if (itemstack.func_77952_i() != 15) {
            return super.func_77659_a(itemstack, world, player, hand);
        }
        Vector3 v = Vector3.getNewVector();
        int range = 5;
        int num = 1;
        float power = 0.11f;
        for (int i = 0; i < num; ++i) {
            v.set(player).addTo((double)range * (Math.random() - 0.5), (double)range * (Math.random() - 0.5), (double)range * (Math.random() - 0.5));
            ExplosionCustom boom = new ExplosionCustom(world, (Entity)player, v, power);
            boom.doExplosion();
        }
        return super.func_77659_a(itemstack, world, player, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stackIn, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int toDrain = 0;
        Vector3 hit = Vector3.getNewVector().set(pos);
        Vector3 next = hit.offset(side);
        boolean full = !playerIn.func_70093_af();
        ArrayList<ItemStack> tanks = this.getTanks(playerIn);
        if (tanks.size() == 0) {
            return EnumActionResult.FAIL;
        }
        if (next.getBlockMaterial((IBlockAccess)worldIn).func_76222_j()) {
            for (ItemStack stack : tanks) {
                IFluidContainerItem tank = (IFluidContainerItem)stack.func_77973_b();
                Fluid f1 = tank.getFluid(stack).getFluid();
                if (!f1.canBePlacedInWorld()) continue;
                Block b = f1.getBlock();
                if (b instanceof BlockFluidBase) {
                    BlockFluidBase block = (BlockFluidBase)b;
                    int maxMeta = block.getMaxRenderHeightMeta();
                    int metaDiff = full ? 16 : 1;
                    toDrain = maxMeta == 0 ? 1000 : (int)((float)metaDiff * 1000.0f / (float)(maxMeta + 1));
                    next.setBlock(worldIn, b, metaDiff - 1, 3);
                    tank.drain(stack, toDrain, !playerIn.field_71075_bZ.field_75098_d);
                    break;
                }
                tank.drain(stack, 1000, !playerIn.field_71075_bZ.field_75098_d);
                next.setBlock(worldIn, b, 0, 3);
            }
        }
        return EnumActionResult.FAIL;
    }
}

