/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.config;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import thut.core.common.config.Configure;

public abstract class ConfigBase
extends Configuration {
    private final ConfigBase defaults;

    public ConfigBase(ConfigBase defaults) {
        this.defaults = defaults;
    }

    public ConfigBase(File path, ConfigBase defaults) {
        super(path);
        this.defaults = defaults;
    }

    protected abstract void applySettings();

    protected void populateSettings() {
        this.populateSettings(false);
    }

    protected void populateSettings(boolean writing) {
        Class<?> me = ((Object)((Object)this)).getClass();
        HashSet<Property> fields = new HashSet<Property>();
        for (Field f : me.getDeclaredFields()) {
            Configure c = f.getAnnotation(Configure.class);
            if (c == null) continue;
            try {
                Property p = null;
                f.setAccessible(true);
                if (f.getType() == Long.TYPE || f.getType() == Long.class) {
                    long defaultValue = f.getLong((Object)this.defaults);
                    p = this.get(c.category(), f.getName(), (int)defaultValue);
                    if (writing) {
                        defaultValue = f.getLong((Object)this);
                        p.set(defaultValue);
                    } else {
                        long value = p.getInt();
                        f.set((Object)this, value);
                    }
                } else if (f.getType() == String.class) {
                    String defaultValue = (String)f.get((Object)this.defaults);
                    p = this.get(c.category(), f.getName(), defaultValue);
                    if (writing) {
                        defaultValue = (String)f.get((Object)this);
                        p.set(defaultValue);
                    } else {
                        String value = p.getString();
                        f.set((Object)this, value);
                    }
                } else if (f.getType() == Integer.TYPE || f.getType() == Integer.class) {
                    int defaultValue = f.getInt((Object)this.defaults);
                    p = this.get(c.category(), f.getName(), defaultValue);
                    if (writing) {
                        defaultValue = f.getInt((Object)this);
                        p.set(defaultValue);
                    } else {
                        int value = p.getInt();
                        f.set((Object)this, value);
                    }
                } else if (f.getType() == Float.TYPE || f.getType() == Float.class) {
                    float defaultValue = f.getFloat((Object)this.defaults);
                    p = this.get(c.category(), f.getName(), defaultValue);
                    if (writing) {
                        defaultValue = f.getFloat((Object)this);
                        p.set((double)defaultValue);
                    } else {
                        float value = (float)p.getDouble();
                        f.set((Object)this, Float.valueOf(value));
                    }
                } else if (f.getType() == Double.TYPE || f.getType() == Double.class) {
                    double defaultValue = f.getDouble((Object)this.defaults);
                    p = this.get(c.category(), f.getName(), defaultValue);
                    if (writing) {
                        defaultValue = f.getDouble((Object)this);
                        p.set(defaultValue);
                    } else {
                        double value = p.getDouble();
                        f.set((Object)this, value);
                    }
                } else if (f.getType() == Boolean.TYPE || f.getType() == Boolean.class) {
                    boolean defaultValue = f.getBoolean((Object)this.defaults);
                    p = this.get(c.category(), f.getName(), defaultValue);
                    if (writing) {
                        defaultValue = f.getBoolean((Object)this);
                        p.set(defaultValue);
                    } else {
                        boolean value = p.getBoolean();
                        f.set((Object)this, value);
                    }
                } else {
                    Object[] defaultValue;
                    Object o = f.get((Object)this.defaults);
                    if (o instanceof String[]) {
                        defaultValue = (String[])o;
                        p = this.get(c.category(), f.getName(), (String[])defaultValue);
                        if (writing) {
                            o = f.get((Object)this);
                            defaultValue = (String[])o;
                            p.set(defaultValue);
                        } else {
                            String[] value = p.getStringList();
                            f.set((Object)this, value);
                        }
                    } else if (o instanceof int[]) {
                        defaultValue = (int[])o;
                        p = this.get(c.category(), f.getName(), (int[])defaultValue);
                        if (writing) {
                            o = f.get((Object)this);
                            defaultValue = (int[])o;
                            p.set((int[])defaultValue);
                        } else {
                            int[] value = p.getIntList();
                            f.set((Object)this, value);
                        }
                    } else {
                        System.err.println("Unknown Type " + f.getType() + " " + f.getName() + " " + o.getClass());
                    }
                }
                if (p == null) continue;
                p.setLanguageKey("pokecube.config." + f.getName());
                fields.add(p);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        ArrayList<ConfigCategory> empty = new ArrayList<ConfigCategory>();
        for (String s : this.getCategoryNames()) {
            ConfigCategory cc = this.getCategory(s);
            cc.setLanguageKey("pokecube.config." + cc.getName());
            ArrayList removeThis = new ArrayList();
            if (cc.entrySet().isEmpty()) {
                empty.add(cc);
            }
            for (Map.Entry e : cc.entrySet()) {
                if (fields.contains(e.getValue())) continue;
                removeThis.add(e.getKey());
            }
            for (String g : removeThis) {
                cc.remove((Object)g);
            }
        }
        for (ConfigCategory cat : empty) {
            this.removeCategory(cat);
        }
    }

    public void updateField(Field field, String update) throws Exception {
        this.load();
        Property p = null;
        Configure c = field.getAnnotation(Configure.class);
        if (field.getType() == Long.TYPE || field.getType() == Long.class) {
            long defaultValue = field.getLong((Object)this.defaults);
            field.set((Object)this, Long.parseLong(update));
            p = this.get(c.category(), field.getName(), (int)defaultValue);
            defaultValue = field.getLong((Object)this);
            p.set(defaultValue);
        } else if (field.getType() == String.class) {
            String defaultValue = (String)field.get((Object)this.defaults);
            field.set((Object)this, update);
            p = this.get(c.category(), field.getName(), defaultValue);
            defaultValue = (String)field.get((Object)this);
            p.set(defaultValue);
        } else if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
            int defaultValue = field.getInt((Object)this.defaults);
            field.set((Object)this, Integer.parseInt(update));
            p = this.get(c.category(), field.getName(), defaultValue);
            defaultValue = field.getInt((Object)this);
            p.set(defaultValue);
        } else if (field.getType() == Float.TYPE || field.getType() == Float.class) {
            float defaultValue = field.getFloat((Object)this.defaults);
            field.set((Object)this, Float.valueOf(Float.parseFloat(update)));
            p = this.get(c.category(), field.getName(), defaultValue);
            defaultValue = field.getFloat((Object)this);
            p.set((double)defaultValue);
        } else if (field.getType() == Double.TYPE || field.getType() == Double.class) {
            double defaultValue = field.getDouble((Object)this.defaults);
            field.set((Object)this, Double.parseDouble(update));
            p = this.get(c.category(), field.getName(), defaultValue);
            defaultValue = field.getDouble((Object)this);
            p.set(defaultValue);
        } else if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            boolean defaultValue = field.getBoolean((Object)this.defaults);
            field.set((Object)this, Boolean.parseBoolean(update));
            p = this.get(c.category(), field.getName(), defaultValue);
            defaultValue = field.getBoolean((Object)this);
            p.set(defaultValue);
        } else {
            Object o = field.get((Object)this.defaults);
            if (o instanceof String[]) {
                String[] defaultValue = (String[])o;
                String[] vars = update.split("``");
                field.set((Object)this, vars);
                p = this.get(c.category(), field.getName(), defaultValue);
                o = field.get((Object)this);
                defaultValue = (String[])o;
                p.set(defaultValue);
            } else if (o instanceof int[]) {
                int[] defaultValue = (int[])o;
                String[] vars = update.split("`");
                int[] toSet = new int[vars.length];
                for (int i = 0; i < vars.length; ++i) {
                    toSet[i] = Integer.parseInt(vars[i]);
                }
                p = this.get(c.category(), field.getName(), defaultValue);
                o = field.get((Object)this);
                defaultValue = (int[])o;
                p.set(defaultValue);
            } else {
                System.err.println("Unknown Type " + field.getType() + " " + field.getName() + " " + o.getClass());
            }
        }
        this.applySettings();
        this.save();
    }
}

