/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.x3d;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.lwjgl.opengl.GL11;
import thut.core.client.render.model.IPartTexturer;
import thut.core.client.render.model.TextureCoordinate;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.x3d.Material;

public class Shape {
    private int meshId = 0;
    public Vertex[] vertices;
    public Vertex[] normals;
    public TextureCoordinate[] textureCoordinates;
    public Integer[] order;
    private Material material;
    public String name;
    private double[] uvShift = new double[]{0.0, 0.0};

    public Shape(Integer[] order, Vertex[] vert, Vertex[] norm, TextureCoordinate[] tex) {
        this.order = order;
        this.vertices = vert;
        this.normals = norm;
        this.textureCoordinates = tex;
    }

    void addTris(IPartTexturer texturer) {
        Vertex vertex;
        Vector3f[] normalList = new Vector3f[this.order.length];
        boolean flat = true;
        if (texturer != null) {
            flat = texturer.isFlat(this.name);
        }
        if (flat) {
            for (int i = 0; i < this.order.length; i += 3) {
                vertex = this.vertices[this.order[i]];
                Vector3f v1 = new Vector3f(vertex.x, vertex.y, vertex.z);
                vertex = this.vertices[this.order[i + 1]];
                Vector3f v2 = new Vector3f(vertex.x, vertex.y, vertex.z);
                vertex = this.vertices[this.order[i + 2]];
                Vector3f v3 = new Vector3f(vertex.x, vertex.y, vertex.z);
                Vector3f a = new Vector3f(v2);
                a.sub((Tuple3f)v1);
                Vector3f b = new Vector3f(v3);
                b.sub((Tuple3f)v1);
                Vector3f c = new Vector3f();
                c.cross(a, b);
                c.normalize();
                normalList[i] = c;
                normalList[i + 1] = c;
                normalList[i + 2] = c;
            }
            GL11.glShadeModel((int)7424);
        } else {
            GL11.glShadeModel((int)7425);
        }
        GL11.glBegin((int)4);
        int n = 0;
        for (Integer i : this.order) {
            TextureCoordinate textureCoordinate = this.textureCoordinates[i];
            GL11.glTexCoord2d((double)textureCoordinate.u, (double)textureCoordinate.v);
            vertex = this.vertices[i];
            if (flat) {
                Vector3f norm = normalList[n];
                GL11.glNormal3f((float)norm.x, (float)norm.y, (float)norm.z);
            } else {
                Vertex normal = this.normals[i];
                GL11.glNormal3f((float)normal.x, (float)normal.y, (float)normal.z);
            }
            ++n;
            GL11.glVertex3f((float)vertex.x, (float)vertex.y, (float)vertex.z);
        }
        GL11.glEnd();
    }

    private void compileList(IPartTexturer texturer) {
        if (!GL11.glIsList((int)this.meshId)) {
            if (this.material != null && texturer != null && !texturer.hasMapping(this.material.name) && this.material.texture != null) {
                texturer.addMapping(this.material.name, this.material.texture);
            }
            this.meshId = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.meshId, (int)4864);
            this.addTris(texturer);
            GL11.glEndList();
        }
    }

    public void renderShape(IPartTexturer texturer) {
        this.compileList(texturer);
        boolean textureShift = false;
        if (texturer != null) {
            texturer.applyTexture(this.name);
            textureShift = texturer.shiftUVs(this.name, this.uvShift);
            if (textureShift) {
                GL11.glMatrixMode((int)5890);
                GL11.glTranslated((double)this.uvShift[0], (double)this.uvShift[1], (double)0.0);
                GL11.glMatrixMode((int)5888);
            }
        }
        if (this.material != null) {
            this.material.preRender();
        }
        GL11.glCallList((int)this.meshId);
        GL11.glFlush();
        if (this.material != null) {
            this.material.postRender();
        }
        if (textureShift) {
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
        }
    }

    public void setMaterial(Material material) {
        this.material = material;
        this.name = material.name;
    }
}

