/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.x3d;

import java.nio.FloatBuffer;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Material {
    public final String name;
    public String texture;
    public Vector3f diffuseColor;
    public Vector3f specularColor;
    public Vector3f emissiveColor;
    public float emissiveMagnitude;
    public float ambientIntensity;
    public float shininess;
    public float transparency;
    boolean depth;
    boolean colour_mat;
    boolean light;
    float[] oldLight = new float[]{-1.0f, -1.0f};

    public Material(String name) {
        this.name = name;
    }

    public Material(String name, String texture, Vector3f diffuse, Vector3f specular, Vector3f emissive, float ambient, float shiny, float transparent) {
        this.name = name;
        this.texture = texture;
        this.diffuseColor = diffuse;
        this.specularColor = specular;
        this.emissiveColor = emissive;
        this.ambientIntensity = ambient;
        this.shininess = shiny;
        this.transparency = transparent;
        this.emissiveMagnitude = Math.min(1.0f, (float)((double)this.emissiveColor.length() / Math.sqrt(3.0)) / 0.8f);
    }

    private FloatBuffer makeBuffer(float value) {
        FloatBuffer ret = BufferUtils.createFloatBuffer((int)5);
        ret.put(new float[]{value});
        return ret;
    }

    private FloatBuffer makeBuffer(Vector3f vector) {
        FloatBuffer ret = BufferUtils.createFloatBuffer((int)7);
        ret.put(new float[]{vector.x, vector.y, vector.z});
        return ret;
    }

    public void postRender() {
        if (!this.depth) {
            GL11.glDisable((int)2929);
        }
        if (!this.colour_mat) {
            GL11.glDisable((int)2903);
        }
        if (!this.light) {
            GL11.glDisable((int)2896);
        } else {
            GL11.glEnable((int)2896);
        }
        if (this.emissiveMagnitude != 0.0f && this.oldLight[0] != -1.0f && this.oldLight[1] != -1.0f) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.oldLight[0], (float)this.oldLight[1]);
        }
    }

    public void preRender() {
        this.depth = GL11.glGetBoolean((int)2929);
        this.colour_mat = GL11.glGetBoolean((int)2903);
        this.light = GL11.glGetBoolean((int)2896);
        GL11.glEnable((int)2929);
        GL11.glMaterial((int)1028, (int)4608, (FloatBuffer)this.makeBuffer(this.ambientIntensity));
        GL11.glMaterial((int)1028, (int)4609, (FloatBuffer)this.makeBuffer(this.diffuseColor));
        GL11.glMaterial((int)1028, (int)4610, (FloatBuffer)this.makeBuffer(this.specularColor));
        GL11.glMaterial((int)1028, (int)5633, (FloatBuffer)this.makeBuffer(this.shininess));
        GL11.glMaterial((int)1028, (int)5632, (FloatBuffer)this.makeBuffer(this.emissiveColor));
        GL11.glEnable((int)2903);
        if (this.emissiveMagnitude != 0.0f) {
            GL11.glDisable((int)2896);
            this.oldLight[0] = OpenGlHelper.lastBrightnessX;
            this.oldLight[1] = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(240.0f * this.emissiveMagnitude), (float)OpenGlHelper.lastBrightnessY);
        } else {
            GL11.glEnable((int)2896);
        }
    }
}

