/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.tabula.model.modelbase;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thut.api.entity.IMobColourable;
import thut.core.client.render.model.IAnimationChanger;
import thut.core.client.render.model.IPartTexturer;
import thut.core.client.render.model.IRetexturableModel;
import thut.core.client.render.tabula.model.modelbase.TabulaModelBase;

@SideOnly(value=Side.CLIENT)
public class TabulaRenderer
extends ModelRenderer
implements IRetexturableModel {
    static final float ratio = 57.295776f;
    private float initRotateAngleX;
    private float initRotateAngleY;
    private float initRotateAngleZ;
    private float initOffsetX;
    private float initOffsetY;
    private float initOffsetZ;
    private float initRotationPointX;
    private float initRotationPointY;
    private float initRotationPointZ;
    private float initScaleX = 1.0f;
    private float initScaleY = 1.0f;
    private float initScaleZ = 1.0f;
    private ModelRenderer parent;
    private boolean hasInitPose;
    private boolean compiled;
    private int displayList;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public String name;
    public String identifier;
    private IAnimationChanger set;
    IPartTexturer texturer;
    double[] texOffsets = new double[]{0.0, 0.0};
    boolean offset = true;
    boolean rotate = true;
    boolean translate = true;
    boolean shouldScale = true;
    public boolean transluscent = false;

    public TabulaRenderer(ModelBase modelBase) {
        super(modelBase);
    }

    public TabulaRenderer(ModelBase modelBase, int x, int y) {
        super(modelBase, x, y);
        if (modelBase instanceof TabulaModelBase) {
            TabulaModelBase mowzieModelBase = (TabulaModelBase)modelBase;
            mowzieModelBase.addPart(this);
        }
    }

    public TabulaRenderer(ModelBase modelBase, String name) {
        super(modelBase, name);
    }

    public void func_78792_a(ModelRenderer renderer) {
        super.func_78792_a(renderer);
        if (renderer instanceof TabulaRenderer) {
            ((TabulaRenderer)renderer).setParent(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void compileDisplayList(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        for (Object object : this.field_78804_l) {
            ((ModelBox)object).func_178780_a(Tessellator.func_178181_a().func_178180_c(), scale);
        }
        GL11.glEndList();
        this.compiled = true;
    }

    public ModelRenderer getParent() {
        return this.parent;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float scale, Entity entity) {
        if (this.set == null) {
            return;
        }
        GL11.glPushMatrix();
        this.field_78807_k = this.set.isPartHidden(this.identifier, entity, this.field_78807_k);
        if (!this.field_78807_k && this.field_78806_j) {
            this.translate = this.field_78800_c != 0.0f || this.field_78797_d != 0.0f || this.field_78798_e != 0.0f;
            this.rotate = this.field_78795_f != 0.0f || this.field_78796_g != 0.0f || this.field_78808_h != 0.0f;
            this.offset = this.field_82906_o != 0.0f || this.field_82908_p != 0.0f || this.field_82907_q != 0.0f;
            this.shouldScale = this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f;
            boolean bl = this.shouldScale = this.shouldScale && this.scaleX != 0.0f && this.scaleY != 0.0f && this.scaleZ != 0.0f;
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            float f5 = 0.0625f;
            if (this.translate) {
                GL11.glTranslatef((float)(this.field_78800_c * f5), (float)(this.field_78797_d * f5), (float)(this.field_78798_e * f5));
            }
            if (this.offset) {
                GL11.glTranslatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
            }
            if (this.shouldScale) {
                GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            }
            if (this.translate) {
                GL11.glTranslatef((float)(-this.field_78800_c * f5), (float)(-this.field_78797_d * f5), (float)(-this.field_78798_e * f5));
            }
            if (this.set.isHeadRoot(this.identifier)) {
                this.rotateHead(entity, this.set.getHeadInfo(), scale);
            }
            GL11.glPushMatrix();
            if (this.translate) {
                GL11.glTranslatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            }
            if (this.rotate) {
                if (this.field_78808_h != 0.0f) {
                    GL11.glRotatef((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_78796_g != 0.0f) {
                    GL11.glRotatef((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_78795_f != 0.0f) {
                    GL11.glRotatef((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
            GL11.glPushMatrix();
            int rgba = 0;
            boolean perPart = true;
            if (entity instanceof IMobColourable) {
                int[] cols = ((IMobColourable)entity).getRGBA();
                rgba += cols[0];
                rgba += cols[1] << 8;
                rgba += cols[2] << 16;
                rgba += cols[3] << 24;
                if (cols[0] == 0 && cols[1] == 0 && cols[2] == 0) {
                    perPart = false;
                }
            } else {
                rgba = -1;
            }
            if (perPart) {
                rgba = this.set.getColourForPart(this.identifier, entity, rgba);
            }
            float alpha = (float)(rgba >> 24 & 0xFF) / 255.0f;
            float red = (float)(rgba >> 16 & 0xFF) / 255.0f;
            float green = (float)(rgba >> 8 & 0xFF) / 255.0f;
            float blue = (float)(rgba & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
            boolean animateTex = false;
            if (this.texturer != null) {
                this.texturer.applyTexture(this.name);
                this.texturer.shiftUVs(this.name, this.texOffsets);
                if (this.texOffsets[0] != 0.0 || this.texOffsets[1] != 0.0) {
                    animateTex = true;
                }
                if (animateTex) {
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    GL11.glTranslated((double)this.texOffsets[0], (double)this.texOffsets[1], (double)0.0);
                    GL11.glMatrixMode((int)5888);
                }
            }
            GL11.glCallList((int)this.displayList);
            if (animateTex) {
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
            }
            GL11.glPopMatrix();
            if (this.field_78805_m != null) {
                for (int i = 0; i < this.field_78805_m.size(); ++i) {
                    ((TabulaRenderer)this.field_78805_m.get(i)).render(scale, entity);
                }
            }
            GL11.glPopMatrix();
            if (this.offset) {
                GL11.glTranslatef((float)(-this.field_82906_o), (float)(-this.field_82908_p), (float)(-this.field_82907_q));
            }
            if (this.shouldScale) {
                GL11.glScalef((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
            }
        }
        GL11.glPopMatrix();
    }

    private void rotateHead(Entity entity, float[] headInfo, float scale) {
        float head = entity.func_70079_am() % 360.0f + 180.0f;
        float diff = 0.0f;
        float body = entity.field_70177_z % 360.0f;
        if (headInfo[2] == 1.0f) {
            body *= -1.0f;
        } else {
            head *= -1.0f;
        }
        diff = (head + body) % 360.0f;
        diff = (diff + 360.0f) % 360.0f;
        diff = (diff - 180.0f) % 360.0f;
        diff = Math.max(diff, headInfo[0]);
        float ang = diff = Math.min(diff, headInfo[1]);
        float ang2 = Math.max(entity.field_70125_A, headInfo[3]);
        ang2 = Math.min(ang2, headInfo[4]);
        GL11.glTranslatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
        this.rotateToParent();
        if (headInfo[5] == 2.0f) {
            GlStateManager.func_179114_b((float)ang, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179114_b((float)ang, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179114_b((float)ang2, (float)1.0f, (float)0.0f, (float)0.0f);
        this.unRotateToParent();
        GL11.glTranslatef((float)(-this.field_78800_c * scale), (float)(-this.field_78797_d * scale), (float)(-this.field_78798_e * scale));
    }

    private void rotateToParent() {
        if (this.parent != null) {
            if (this.parent instanceof TabulaRenderer) {
                ((TabulaRenderer)this.parent).rotateToParent();
            }
            if (this.parent.field_78808_h != 0.0f) {
                GL11.glRotatef((float)(this.parent.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)-1.0f);
            }
            if (this.parent.field_78796_g != 0.0f) {
                GL11.glRotatef((float)(this.parent.field_78796_g * 57.295776f), (float)0.0f, (float)-1.0f, (float)0.0f);
            }
            if (this.parent.field_78795_f != 0.0f) {
                GL11.glRotatef((float)(this.parent.field_78795_f * 57.295776f), (float)-1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    @Override
    public void setAnimationChanger(IAnimationChanger changer) {
        this.set = changer;
        if (this.field_78805_m != null) {
            for (ModelRenderer r : this.field_78805_m) {
                if (!(r instanceof IRetexturableModel)) continue;
                ((IRetexturableModel)r).setAnimationChanger(changer);
            }
        }
    }

    public void setCurrentPoseToInitValues() {
        if (this.hasInitPose) {
            this.field_78795_f = this.initRotateAngleX;
            this.field_78796_g = this.initRotateAngleY;
            this.field_78808_h = this.initRotateAngleZ;
            this.field_78800_c = this.initRotationPointX;
            this.field_78797_d = this.initRotationPointY;
            this.field_78798_e = this.initRotationPointZ;
            this.field_82906_o = this.initOffsetX;
            this.field_82908_p = this.initOffsetY;
            this.field_82907_q = this.initOffsetZ;
            this.scaleX = this.initScaleX;
            this.scaleY = this.initScaleY;
            this.scaleZ = this.initScaleZ;
        }
    }

    public void setInitValuesToCurrentPose() {
        this.initRotateAngleX = this.field_78795_f;
        this.initRotateAngleY = this.field_78796_g;
        this.initRotateAngleZ = this.field_78808_h;
        this.initRotationPointX = this.field_78800_c;
        this.initRotationPointY = this.field_78797_d;
        this.initRotationPointZ = this.field_78798_e;
        this.initOffsetX = this.field_82906_o;
        this.initOffsetY = this.field_82908_p;
        this.initOffsetZ = this.field_82907_q;
        this.initScaleX = this.scaleX;
        this.initScaleY = this.scaleY;
        this.initScaleZ = this.scaleZ;
        this.hasInitPose = true;
    }

    private void setParent(ModelRenderer modelRenderer) {
        this.parent = modelRenderer;
    }

    public void setRotationAngles(float x, float y, float z) {
        this.field_78795_f = x;
        this.field_78796_g = y;
        this.field_78808_h = z;
    }

    public void setScale(float x, float y, float z) {
        this.scaleX = x;
        this.scaleY = y;
        this.scaleZ = z;
    }

    @Override
    public void setTexturer(IPartTexturer texturer) {
        this.texturer = texturer;
        if (this.field_78805_m != null) {
            for (Object part : this.field_78805_m) {
                if (!(part instanceof IRetexturableModel)) continue;
                ((IRetexturableModel)part).setTexturer(texturer);
            }
        }
    }

    private void unRotateToParent() {
        if (this.parent != null) {
            if (this.parent instanceof TabulaRenderer) {
                ((TabulaRenderer)this.parent).unRotateToParent();
            }
            if (this.parent.field_78808_h != 0.0f) {
                GL11.glRotatef((float)(this.parent.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.parent.field_78796_g != 0.0f) {
                GL11.glRotatef((float)(this.parent.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.parent.field_78795_f != 0.0f) {
                GL11.glRotatef((float)(this.parent.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }
}

