/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.tabula.animation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;

public class SnakeMovement
extends Animation {
    public SnakeMovement() {
        this.loops = true;
        this.name = "walking";
    }

    public SnakeMovement init(ArrayList<String> parts, int duration, float maxAngle, int axis) {
        float angle = maxAngle;
        int num = parts.size();
        int mod = num > 6 ? 3 : 2;
        for (int i = 0; i < parts.size(); ++i) {
            String ident = "";
            String s = parts.get(i);
            angle = (float)(Math.sin((double)i * Math.PI / (double)(2 * mod) - 1.5707963267948966) * (double)maxAngle);
            AnimationComponent component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = ident + "1";
            component1.identifier = ident + "1";
            component1.startKey = 0;
            component1.rotChange[axis] = angle;
            AnimationComponent component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = ident + "2";
            component2.identifier = ident + "2";
            component2.startKey = duration / 4;
            component2.rotChange[axis] = -2.0f * angle;
            AnimationComponent component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = ident + "3";
            component3.identifier = ident + "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[axis] = angle;
            ArrayList set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        return this;
    }

    @Override
    public Animation init(NamedNodeMap map, AnimationRegistry.IPartRenamer renamer) {
        ArrayList<String> parts = new ArrayList<String>();
        int duration = 40;
        int axis = 1;
        float maxAngle = 10.0f;
        String[] partsArr = map.getNamedItem("parts").getNodeValue().split(":");
        if (renamer != null) {
            renamer.convertToIdents(partsArr);
        }
        for (String s : partsArr) {
            if (s == null) continue;
            parts.add(s);
        }
        if (map.getNamedItem("angle") != null) {
            maxAngle = Float.parseFloat(map.getNamedItem("angle").getNodeValue());
        }
        if (map.getNamedItem("axis") != null) {
            axis = Integer.parseInt(map.getNamedItem("axis").getNodeValue());
        }
        if (map.getNamedItem("length") != null) {
            duration = Integer.parseInt(map.getNamedItem("length").getNodeValue());
        }
        if (map.getNamedItem("duration") != null) {
            duration = Integer.parseInt(map.getNamedItem("duration").getNodeValue());
        }
        this.init(parts, duration, maxAngle, axis);
        return this;
    }
}

