/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.smd;

import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraftforge.client.model.obj.OBJModel;
import org.lwjgl.opengl.GL11;
import thut.core.client.render.smd.SMDModel;
import thut.core.client.render.smd.Skeleton;

public class Triangles {
    ArrayList<Triangle> triangles = new ArrayList();
    final SMDModel model;

    public Triangles(SMDModel model) {
        this.model = model;
    }

    public void render() {
        GL11.glPushMatrix();
        GL11.glBegin((int)4);
        boolean smooth = true;
        for (Triangle t : this.triangles) {
            if (t == null) continue;
            t.preRender();
            t.addForRender(smooth);
            t.postRender();
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static class Triangle {
        final String material;
        final Triangles triangles;
        int[] parentBoneIds = new int[3];
        Skeleton.BoneVertex[] vertices = new Skeleton.BoneVertex[3];
        Vector3f faceNormal;
        OBJModel.TextureCoordinate[] uvs = new OBJModel.TextureCoordinate[3];
        int toAdd = 0;

        public Triangle(String material, Triangles triangles) {
            this.triangles = triangles;
            this.material = material;
        }

        public void addForRender(boolean smoothShading) {
            if (!smoothShading && this.faceNormal == null) {
                this.calculateFaceNormal();
            }
            for (int i = 0; i < 3; ++i) {
                GL11.glTexCoord2f((float)this.uvs[i].u, (float)this.uvs[i].v);
                if (!smoothShading) {
                    GL11.glNormal3f((float)this.faceNormal.x, (float)this.faceNormal.y, (float)this.faceNormal.z);
                } else {
                    GL11.glNormal3f((float)this.vertices[i].xn, (float)this.vertices[i].yn, (float)this.vertices[i].zn);
                }
                GL11.glVertex3d((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z);
            }
        }

        public void addVertex(String line) {
            int i;
            line = line.replaceAll("\\s+", " ");
            String[] args = line.split(" ");
            Skeleton.BoneVertex vertex = new Skeleton.BoneVertex(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]), Float.parseFloat(args[4]), Float.parseFloat(args[5]), Float.parseFloat(args[6]), this.triangles.model.getNextVertexID());
            int links = Integer.parseInt(args[9]);
            float[] weights = new float[links];
            float sum = 0.0f;
            for (i = 0; i < links; ++i) {
                weights[i] = Float.parseFloat(args[i * 2 + 11]);
                sum += weights[i];
            }
            for (i = 0; i < links; ++i) {
                int boneID = Integer.parseInt(args[i * 2 + 10]);
                float weight = weights[i] / sum;
                this.triangles.model.skeleton.getBone((int)boneID).vertices.put(vertex, Float.valueOf(weight));
            }
            this.uvs[this.toAdd] = new OBJModel.TextureCoordinate(Float.parseFloat(args[7]), Float.parseFloat(args[8]), 0.0f);
            this.vertices[this.toAdd] = vertex;
            ++this.toAdd;
        }

        public void calculateFaceNormal() {
            Vector3f v1 = new Vector3f(this.vertices[0].x, this.vertices[0].y, this.vertices[0].z);
            Vector3f v2 = new Vector3f(this.vertices[1].x, this.vertices[1].y, this.vertices[1].z);
            Vector3f v3 = new Vector3f(this.vertices[2].x, this.vertices[2].y, this.vertices[2].z);
            Vector3f a = new Vector3f(v2);
            a.sub((Tuple3f)v1);
            Vector3f b = new Vector3f(v3);
            b.sub((Tuple3f)v1);
            Vector3f c = new Vector3f();
            c.cross(a, b);
            c.normalize();
            this.faceNormal = c;
        }

        public void postRender() {
        }

        public void preRender() {
        }

        public String toString() {
            if (this.faceNormal == null) {
                this.calculateFaceNormal();
            }
            return Arrays.toString(this.vertices) + " " + this.faceNormal;
        }
    }
}

