/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;

public class AnimationHelper {
    public static boolean doAnimation(Animation animation, Entity entity, String partName, IExtendedModelPart part, float partialTick) {
        ArrayList<AnimationComponent> components = animation.getComponents(partName);
        if (animation.getLength() < 0) {
            animation.initLength();
        }
        int animationLength = animation.getLength();
        boolean animate = false;
        Vector3 temp = Vector3.getNewVector();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float sx = 1.0f;
        float sy = 1.0f;
        float sz = 1.0f;
        float time = (float)entity.field_70173_aa + partialTick;
        time %= (float)animationLength;
        if (components != null) {
            for (AnimationComponent component : components) {
                if (!(time >= (float)component.startKey)) continue;
                animate = true;
                float componentTimer = time - (float)component.startKey;
                if (componentTimer > (float)component.length) {
                    componentTimer = component.length;
                }
                temp.addTo(component.posChange[0] / (double)component.length * (double)componentTimer + component.posOffset[0], component.posChange[1] / (double)component.length * (double)componentTimer + component.posOffset[1], component.posChange[2] / (double)component.length * (double)componentTimer + component.posOffset[2]);
                x += (float)(component.rotChange[0] / (double)component.length * (double)componentTimer + component.rotOffset[0]);
                y += (float)(component.rotChange[1] / (double)component.length * (double)componentTimer + component.rotOffset[1]);
                z += (float)(component.rotChange[2] / (double)component.length * (double)componentTimer + component.rotOffset[2]);
                sx += (float)(component.scaleChange[0] / (double)component.length * (double)componentTimer + component.scaleOffset[0]);
                sy += (float)(component.scaleChange[1] / (double)component.length * (double)componentTimer + component.scaleOffset[1]);
                sz += (float)(component.scaleChange[2] / (double)component.length * (double)componentTimer + component.scaleOffset[2]);
            }
        }
        if (animate) {
            part.setPreTranslations(temp);
            part.setPreScale(temp.set(sx, sy, sz));
            Vector4 angle = null;
            if (z != 0.0f) {
                angle = new Vector4(0.0, 0.0, 1.0, z);
            }
            if (y != 0.0f) {
                angle = angle != null ? angle.addAngles(new Vector4(0.0, 1.0, 0.0, y)) : new Vector4(0.0, 1.0, 0.0, y);
            }
            if (x != 0.0f) {
                angle = angle != null ? angle.addAngles(new Vector4(1.0, 0.0, 0.0, x)) : new Vector4(1.0, 0.0, 0.0, x);
            }
            if (angle != null) {
                part.setPreRotations(angle);
            }
        }
        return animate;
    }
}

