/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import thut.api.terrain.TerrainSegment;

public class WorldTerrain {
    public final int dimID;
    private TerrainMap terrainMap = new TerrainMap();

    public WorldTerrain(int dimID) {
        this.dimID = dimID;
    }

    public void addTerrain(TerrainSegment terrain) {
        if (terrain != null) {
            this.terrainMap.setSegment(terrain, terrain.chunkX, terrain.chunkY, terrain.chunkZ);
        }
    }

    public TerrainSegment getTerrain(int chunkX, int chunkY, int chunkZ) {
        return this.getTerrain(chunkX, chunkY, chunkZ, false);
    }

    public TerrainSegment getTerrain(int chunkX, int chunkY, int chunkZ, boolean saving) {
        TerrainSegment ret = null;
        ret = this.terrainMap.getSegment(chunkX, chunkY, chunkZ);
        if (ret == null && !saving) {
            ret = new TerrainSegment(chunkX, chunkY, chunkZ);
            this.terrainMap.setSegment(ret, chunkX, chunkY, chunkZ);
        }
        return ret;
    }

    public void loadTerrain(NBTTagCompound nbt) {
        this.loadTerrain(nbt, 16);
    }

    public void loadTerrain(NBTTagCompound nbt, int max) {
        int x = nbt.func_74762_e("xCoord");
        int z = nbt.func_74762_e("zCoord");
        max = Math.min(16, max + 1);
        for (int i = 0; i < max; ++i) {
            NBTTagCompound terrainTag = null;
            try {
                terrainTag = nbt.func_74775_l("terrain" + x + "," + i + "," + z + "," + this.dimID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TerrainSegment t = null;
            if (terrainTag != null && !terrainTag.func_82582_d() && (t = TerrainSegment.readFromNBT(terrainTag)) != null) {
                this.addTerrain(t);
            }
            if (t != null) continue;
            this.getTerrain(x, i, x);
        }
    }

    public void removeTerrain(int chunkX, int chunkZ) {
        for (int i = 0; i < 16; ++i) {
            this.terrainMap.setSegment(null, chunkX, i, chunkZ);
        }
    }

    public boolean saveTerrain(NBTTagCompound nbt, int x, int z) {
        nbt.func_74768_a("xCoord", x);
        nbt.func_74768_a("zCoord", z);
        boolean saved = false;
        for (int i = 0; i < 16; ++i) {
            TerrainSegment t = this.getTerrain(x, i, z, true);
            if (t == null) continue;
            t.checkToSave();
            if (!t.toSave) continue;
            saved = true;
            NBTTagCompound terrainTag = new NBTTagCompound();
            t.saveToNBT(terrainTag);
            nbt.func_74782_a("terrain" + x + "," + i + "," + z + "," + this.dimID, (NBTBase)terrainTag);
        }
        return saved;
    }

    public static class TerrainMap {
        final HashMap<Long, TerrainSegment> terrain = new HashMap();

        private Long getKey(int x, int y, int z) {
            long l = (long)x + ((long)z << 21) + ((long)y << 42);
            return new Long(l);
        }

        public TerrainSegment getSegment(int x, int y, int z) {
            y = Math.max(0, y);
            y = Math.min(y, 15);
            Long key = this.getKey(x, y, z);
            return this.terrain.get(key);
        }

        public void setSegment(TerrainSegment t, int x, int y, int z) {
            y = Math.max(0, y);
            y = Math.min(y, 15);
            Long key = this.getKey(x, y, z);
            if (t != null) {
                this.terrain.put(key, t);
            } else {
                this.terrain.remove(key);
            }
        }
    }
}

